package org.jbpm.gd.jpdl.ui.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.ui.graph.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.jpdl.ui.outline.part.JpdlOutlineEditPart;


public class DecisionHandlerSection extends AbstractPropertySection {
	
	private DecisionConfigurationComposite decisionConfigurationComposite;
	private Decision decision;
	
	public void createControls(Composite parent,
            TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite clientArea = getWidgetFactory().createFlatFormComposite(parent);
        Composite decisionInfoArea = getWidgetFactory().createComposite(clientArea);
        decisionInfoArea.setLayout(new FormLayout());
        decisionConfigurationComposite = DecisionConfigurationComposite.create(getWidgetFactory(), decisionInfoArea);
        decisionInfoArea.setLayoutData(createDecisionInfoAreaLayoutData());
    }
	
	private FormData createDecisionInfoAreaLayoutData() {
		FormData result = new FormData();
		result.left = new FormAttachment(0, 0);
		result.top = new FormAttachment(0, 0);
		result.right = new FormAttachment(100, 0);
		result.bottom = new FormAttachment(100, 0);
		return result;
	}
 
 	public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) return;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
        	AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
        	input = notationElement.getSemanticElement();
        } else if (input instanceof JpdlOutlineEditPart) {
        	input = ((JpdlOutlineEditPart)input).getModel();
        }
        if (input instanceof Decision) {
        	decision = (Decision)input;
        	refresh();
        }
    }
 	
 	public void refresh() {
 		if (decision == null){
 			decisionConfigurationComposite.setDecision(null);
 		} else {
 			decisionConfigurationComposite.setDecision(decision);
 		}
     }
 	
	public boolean shouldUseExtraSpace() {
		return true;
	}
		
}