"use strict";
/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const operator_1 = require("./operator");
/**
 * Tasks related to installation way.
 */
class InstallerTasks {
    updateTasks(flags, command) {
        const operatorTasks = new operator_1.OperatorTasks();
        let title;
        let task;
        // let task: Listr.ListrTask
        if (flags.installer === 'operator') {
            title = '🏃‍  Running the CodeReady Workspaces operator update';
            task = () => {
                return operatorTasks.updateTasks(flags, command);
            };
        }
        else {
            title = '🏃‍  Installer preflight check';
            task = () => { command.error(`Installer ${flags.installer} does not support update ¯\\_(ツ)_/¯`); };
        }
        return [{
                title,
                task
            }];
    }
    preUpdateTasks(flags, command) {
        const operatorTasks = new operator_1.OperatorTasks();
        let title;
        let task;
        // let task: Listr.ListrTask
        if (flags.installer === 'operator') {
            title = '🏃‍  Running the CodeReady Workspaces operator update';
            task = () => {
                return operatorTasks.preUpdateTasks(flags, command);
            };
        }
        else {
            title = '🏃‍  Installer preflight check';
            task = () => { command.error(`Installer ${flags.installer} does not support update ¯\\_(ツ)_/¯`); };
        }
        return [{
                title,
                task
            }];
    }
    installTasks(flags, command) {
        const operatorTasks = new operator_1.OperatorTasks();
        let title;
        let task;
        // let task: Listr.ListrTask
        if (flags.installer === 'operator') {
            title = '🏃‍  Running the CodeReady Workspaces operator';
            task = () => {
                // The operator installs CodeReady Workspaces in multiuser mode only
                if (!flags.multiuser) {
                    command.warn('CodeReady Workspaces can only be deployed in Multi-User mode.');
                    flags.multiuser = true;
                }
                return operatorTasks.startTasks(flags, command);
            };
        }
        else {
            title = '🏃‍  Installer preflight check';
            task = () => { command.error(`Installer ${flags.installer} is not supported ¯\\_(ツ)_/¯`); };
        }
        return [{
                title,
                task
            }];
    }
}
exports.InstallerTasks = InstallerTasks;
//# sourceMappingURL=installer.js.map