# Russian (ru) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                   | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987-й                                            | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5-й                                               | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987-й                                            | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5-й                                               | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1-й                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-й                                               | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | 1-й кв.                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-й кв.                                           | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1-й квартал                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-й квартал                                       | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                 | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1-й                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-й                                               | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 1-й кв.                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-й кв.                                           | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1-й квартал                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-й квартал                                       | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2-й                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-й                                               | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | фев.                                              | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | июл.                                              | Invalid Date             |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | февраля                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | июля                                              | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | Ф                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | И                                                 | 2019-06-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2-й                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-й                                               | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | фев.                                              | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | июль                                              | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | февраль                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | июль                                              | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | Ф                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | И                                                 | 2019-06-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1-я                                               | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-я                                              | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1-я                                               | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-я                                              | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11-е                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28-е                                              | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42-й                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365-й                                             | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | пнд                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | птн                                               | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | пнд                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | птн                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | пнд                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | птн                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | понедельник                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пятница                                           | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | П                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                                 | 2019-02-11T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | пн                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пт                                                | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1-й                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-й                                               | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | пнд                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | птн                                               | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | понедельник                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пятница                                           | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | П                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                                 | 2019-02-11T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | пн                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пт                                                | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1-й                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-й                                               | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | пнд                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | птн                                               | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | понедельник                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пятница                                           | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | П                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                                 | 2019-02-11T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | пн                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пт                                                | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1-й                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-й                                               | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | пнд                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | птн                                               | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | понедельник                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пятница                                           | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | П                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                                 | 2019-02-11T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | пн                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пт                                                | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | утра                                              | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | дня                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | веч.                                              | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ночи                                              | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | утра                                              | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | дня                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | веч.                                              | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ночи                                              | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | утра                                              | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | дня                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | веч.                                              | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ночи                                              | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | утра                                              | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | дня                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | вечера                                            | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ночи                                              | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | утра                                              | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | дня                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | веч.                                              | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ночи                                              | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11-й                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-й                                              | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11-й                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-й                                              | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11-й                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-й                                              | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11-й                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-й                                              | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1-я                                               | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55-я                                              | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1-я                                               | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55-я                                              | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11.02.1987                                        | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453                                        | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 фев. 1987 г.                                   | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 мая 1453 г.                                    | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11-е февраля 1987 г.                              | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29-е мая 1453 г.                                  | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | среда, 11-е февраля 1987 г.                       | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | воскресенье, 29-е мая 1453 г.                     | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                             | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                             | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                          | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                          | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                    | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                                | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11.02.1987, 12:13                                 | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453, 23:59                                 | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 фев. 1987 г., 12:13:14                         | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 мая 1453 г., 23:59:59                          | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11-е февраля 1987 г., 12:13:14 GMT+0              | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29-е мая 1453 г., 23:59:59 GMT+0                  | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | среда, 11-е февраля 1987 г., 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | воскресенье, 29-е мая 1453 г., 23:59:59 GMT+00:00 | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result         | `includeSeconds: true` | `addSuffix: true`            |
| ------------------------ | -------------- | ---------------------- | ---------------------------- |
| 2006-01-01T00:00:00.000Z | около 6 лет    | около 6 лет            | приблизительно через 6 лет   |
| 2005-01-01T00:00:00.000Z | около 5 лет    | около 5 лет            | приблизительно через 5 лет   |
| 2004-01-01T00:00:00.000Z | около 4 лет    | около 4 лет            | приблизительно через 4 года  |
| 2003-01-01T00:00:00.000Z | около 3 лет    | около 3 лет            | приблизительно через 3 года  |
| 2002-01-01T00:00:00.000Z | около 2 лет    | около 2 лет            | приблизительно через 2 года  |
| 2001-06-01T00:00:00.000Z | больше 1 года  | больше 1 года          | больше, чем через 1 год      |
| 2001-02-01T00:00:00.000Z | около 1 года   | около 1 года           | приблизительно через 1 год   |
| 2001-01-01T00:00:00.000Z | около 1 года   | около 1 года           | приблизительно через 1 год   |
| 2000-06-01T00:00:00.000Z | 5 месяцев      | 5 месяцев              | через 5 месяцев              |
| 2000-03-01T00:00:00.000Z | 2 месяца       | 2 месяца               | через 2 месяца               |
| 2000-02-01T00:00:00.000Z | около 1 месяца | около 1 месяца         | приблизительно через 1 месяц |
| 2000-01-15T00:00:00.000Z | 14 дней        | 14 дней                | через 14 дней                |
| 2000-01-02T00:00:00.000Z | 1 день         | 1 день                 | через 1 день                 |
| 2000-01-01T06:00:00.000Z | около 6 часов  | около 6 часов          | приблизительно через 6 часов |
| 2000-01-01T01:00:00.000Z | около 1 часа   | около 1 часа           | приблизительно через 1 час   |
| 2000-01-01T00:45:00.000Z | около 1 часа   | около 1 часа           | приблизительно через 1 час   |
| 2000-01-01T00:30:00.000Z | 30 минут       | 30 минут               | через 30 минут               |
| 2000-01-01T00:15:00.000Z | 15 минут       | 15 минут               | через 15 минут               |
| 2000-01-01T00:01:00.000Z | 1 минута       | 1 минута               | через 1 минуту               |
| 2000-01-01T00:00:25.000Z | меньше минуты  | полминуты              | меньше, чем через минуту     |
| 2000-01-01T00:00:15.000Z | меньше минуты  | меньше 20 секунд       | меньше, чем через минуту     |
| 2000-01-01T00:00:05.000Z | меньше минуты  | меньше 10 секунд       | меньше, чем через минуту     |
| 2000-01-01T00:00:00.000Z | меньше минуты  | меньше 5 секунд        | меньше минуты назад          |
| 1999-12-31T23:59:55.000Z | меньше минуты  | меньше 10 секунд       | меньше минуты назад          |
| 1999-12-31T23:59:45.000Z | меньше минуты  | меньше 20 секунд       | меньше минуты назад          |
| 1999-12-31T23:59:35.000Z | меньше минуты  | полминуты              | меньше минуты назад          |
| 1999-12-31T23:59:00.000Z | 1 минута       | 1 минута               | 1 минуту назад               |
| 1999-12-31T23:45:00.000Z | 15 минут       | 15 минут               | 15 минут назад               |
| 1999-12-31T23:30:00.000Z | 30 минут       | 30 минут               | 30 минут назад               |
| 1999-12-31T23:15:00.000Z | около 1 часа   | около 1 часа           | около 1 часа назад           |
| 1999-12-31T23:00:00.000Z | около 1 часа   | около 1 часа           | около 1 часа назад           |
| 1999-12-31T18:00:00.000Z | около 6 часов  | около 6 часов          | около 6 часов назад          |
| 1999-12-30T00:00:00.000Z | 2 дня          | 2 дня                  | 2 дня назад                  |
| 1999-12-15T00:00:00.000Z | 17 дней        | 17 дней                | 17 дней назад                |
| 1999-12-01T00:00:00.000Z | около 1 месяца | около 1 месяца         | около 1 месяца назад         |
| 1999-11-01T00:00:00.000Z | 2 месяца       | 2 месяца               | 2 месяца назад               |
| 1999-06-01T00:00:00.000Z | 7 месяцев      | 7 месяцев              | 7 месяцев назад              |
| 1999-01-01T00:00:00.000Z | около 1 года   | около 1 года           | около 1 года назад           |
| 1998-12-01T00:00:00.000Z | около 1 года   | около 1 года           | около 1 года назад           |
| 1998-06-01T00:00:00.000Z | больше 1 года  | больше 1 года          | больше 1 года назад          |
| 1998-01-01T00:00:00.000Z | около 2 лет    | около 2 лет            | около 2 лет назад            |
| 1997-01-01T00:00:00.000Z | около 3 лет    | около 3 лет            | около 3 лет назад            |
| 1996-01-01T00:00:00.000Z | около 4 лет    | около 4 лет            | около 4 лет назад            |
| 1995-01-01T00:00:00.000Z | около 5 лет    | около 5 лет            | около 5 лет назад            |
| 1994-01-01T00:00:00.000Z | около 6 лет    | около 6 лет            | около 6 лет назад            |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result    | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | --------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 лет     | через 6 лет       | 52608 часов                    |
| 2005-01-01T00:00:00.000Z | 5 лет     | через 5 лет       | 43848 часов                    |
| 2004-01-01T00:00:00.000Z | 4 года    | через 4 года      | 35064 часа                     |
| 2003-01-01T00:00:00.000Z | 3 года    | через 3 года      | 26304 часа                     |
| 2002-01-01T00:00:00.000Z | 2 года    | через 2 года      | 17544 часа                     |
| 2001-06-01T00:00:00.000Z | 1 год     | через 1 год       | 12408 часов                    |
| 2001-02-01T00:00:00.000Z | 1 год     | через 1 год       | 9528 часов                     |
| 2001-01-01T00:00:00.000Z | 1 год     | через 1 год       | 8784 часа                      |
| 2000-06-01T00:00:00.000Z | 5 месяцев | через 5 месяцев   | 3648 часов                     |
| 2000-03-01T00:00:00.000Z | 2 месяца  | через 2 месяца    | 1440 часов                     |
| 2000-02-01T00:00:00.000Z | 1 месяц   | через 1 месяц     | 744 часа                       |
| 2000-01-15T00:00:00.000Z | 14 дней   | через 14 дней     | 336 часов                      |
| 2000-01-02T00:00:00.000Z | 1 день    | через 1 день      | 24 часа                        |
| 2000-01-01T06:00:00.000Z | 6 часов   | через 6 часов     | 6 часов                        |
| 2000-01-01T01:00:00.000Z | 1 час     | через 1 час       | 1 час                          |
| 2000-01-01T00:45:00.000Z | 45 минут  | через 45 минут    | 1 час                          |
| 2000-01-01T00:30:00.000Z | 30 минут  | через 30 минут    | 1 час                          |
| 2000-01-01T00:15:00.000Z | 15 минут  | через 15 минут    | 0 часов                        |
| 2000-01-01T00:01:00.000Z | 1 минута  | через 1 минуту    | 0 часов                        |
| 2000-01-01T00:00:25.000Z | 25 секунд | через 25 секунд   | 0 часов                        |
| 2000-01-01T00:00:15.000Z | 15 секунд | через 15 секунд   | 0 часов                        |
| 2000-01-01T00:00:05.000Z | 5 секунд  | через 5 секунд    | 0 часов                        |
| 2000-01-01T00:00:00.000Z | 0 секунд  | 0 секунд назад    | 0 часов                        |
| 1999-12-31T23:59:55.000Z | 5 секунд  | 5 секунд назад    | 0 часов                        |
| 1999-12-31T23:59:45.000Z | 15 секунд | 15 секунд назад   | 0 часов                        |
| 1999-12-31T23:59:35.000Z | 25 секунд | 25 секунд назад   | 0 часов                        |
| 1999-12-31T23:59:00.000Z | 1 минута  | 1 минуту назад    | 0 часов                        |
| 1999-12-31T23:45:00.000Z | 15 минут  | 15 минут назад    | 0 часов                        |
| 1999-12-31T23:30:00.000Z | 30 минут  | 30 минут назад    | 1 час                          |
| 1999-12-31T23:15:00.000Z | 45 минут  | 45 минут назад    | 1 час                          |
| 1999-12-31T23:00:00.000Z | 1 час     | 1 час назад       | 1 час                          |
| 1999-12-31T18:00:00.000Z | 6 часов   | 6 часов назад     | 6 часов                        |
| 1999-12-30T00:00:00.000Z | 2 дня     | 2 дня назад       | 48 часов                       |
| 1999-12-15T00:00:00.000Z | 17 дней   | 17 дней назад     | 408 часов                      |
| 1999-12-01T00:00:00.000Z | 1 месяц   | 1 месяц назад     | 744 часа                       |
| 1999-11-01T00:00:00.000Z | 2 месяца  | 2 месяца назад    | 1464 часа                      |
| 1999-06-01T00:00:00.000Z | 7 месяцев | 7 месяцев назад   | 5136 часов                     |
| 1999-01-01T00:00:00.000Z | 1 год     | 1 год назад       | 8760 часов                     |
| 1998-12-01T00:00:00.000Z | 1 год     | 1 год назад       | 9504 часа                      |
| 1998-06-01T00:00:00.000Z | 2 года    | 2 года назад      | 13896 часов                    |
| 1998-01-01T00:00:00.000Z | 2 года    | 2 года назад      | 17520 часов                    |
| 1997-01-01T00:00:00.000Z | 3 года    | 3 года назад      | 26280 часов                    |
| 1996-01-01T00:00:00.000Z | 4 года    | 4 года назад      | 35064 часа                     |
| 1995-01-01T00:00:00.000Z | 5 лет     | 5 лет назад       | 43824 часа                     |
| 1994-01-01T00:00:00.000Z | 6 лет     | 6 лет назад       | 52584 часа                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                   |
| ------------------------ | ------------------------ |
| 2000-01-10T00:00:00.000Z | 10.01.2000               |
| 2000-01-05T00:00:00.000Z | в следующую среду в 0:00 |
| 2000-01-02T00:00:00.000Z | завтра в 0:00            |
| 2000-01-01T00:00:00.000Z | сегодня в 0:00           |
| 1999-12-31T00:00:00.000Z | вчера в 0:00             |
| 1999-12-27T00:00:00.000Z | в понедельник в 0:00     |
| 1999-12-21T00:00:00.000Z | 21.12.1999               |
