/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
/// <reference types="node" />
import { KubeConfig, Log, PortForward, V1beta1CustomResourceDefinition, V1beta1IngressList, V1ClusterRoleBinding, V1ConfigMap, V1Deployment, V1DeploymentList, V1NamespaceList, V1PersistentVolumeClaimList, V1Pod, V1PodList, V1RoleBinding, V1Secret, V1ServiceAccount, V1ServiceList } from '@kubernetes/client-node';
import { Context } from '@kubernetes/client-node/dist/config_types';
export declare class KubeHelper {
    kc: KubeConfig;
    portForwardHelper: PortForward;
    logHelper: Log;
    podWaitTimeout: number;
    podReadyTimeout: number;
    constructor(flags?: any, context?: string);
    deleteAllServices(namespace?: string): Promise<void>;
    getServicesBySelector(labelSelector?: string, namespace?: string): Promise<V1ServiceList>;
    waitForService(selector: string, namespace?: string, intervalMs?: number, timeoutMs?: number): Promise<void>;
    serviceAccountExist(name?: string, namespace?: string): Promise<boolean>;
    createServiceAccount(name?: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1ServiceAccount;
    }>;
    deleteServiceAccount(name?: string, namespace?: string): Promise<void>;
    createServiceAccountFromFile(filePath: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1ServiceAccount;
    }>;
    replaceServiceAccountFromFile(filePath: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1ServiceAccount;
    }>;
    roleExist(name?: string, namespace?: string): Promise<boolean>;
    clusterRoleExist(name?: string): Promise<boolean>;
    createRoleFromFile(filePath: string, namespace?: string): Promise<any>;
    replaceRoleFromFile(filePath: string, namespace?: string): Promise<any>;
    createClusterRoleFromFile(filePath: string): Promise<any>;
    replaceClusterRoleFromFile(filePath: string): Promise<any>;
    deleteRole(name?: string, namespace?: string): Promise<void>;
    deleteClusterRole(name?: string): Promise<void>;
    roleBindingExist(name?: string, namespace?: string): Promise<boolean>;
    clusterRoleBindingExist(name?: string): Promise<boolean | ''>;
    createAdminRoleBinding(name?: string, serviceAccount?: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1RoleBinding;
    }>;
    createRoleBindingFromFile(filePath: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1RoleBinding;
    }>;
    replaceRoleBindingFromFile(filePath: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1RoleBinding;
    }>;
    createClusterRoleBinding(name: string, saName: string, saNamespace?: string, roleName?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1ClusterRoleBinding;
    }>;
    replaceClusterRoleBinding(name: string, saName: string, saNamespace?: string, roleName?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1ClusterRoleBinding;
    }>;
    deleteRoleBinding(name?: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: import("@kubernetes/client-node").V1Status;
    }>;
    deleteClusterRoleBinding(name?: string): Promise<{
        response: import("http").IncomingMessage;
        body: import("@kubernetes/client-node").V1Status;
    }>;
    getConfigMap(name?: string, namespace?: string): Promise<V1ConfigMap | undefined>;
    createConfigMapFromFile(filePath: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1ConfigMap;
    }>;
    patchConfigMap(name: string, patch: any, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1ConfigMap;
    }>;
    deleteConfigMap(name: string, namespace?: string): Promise<void>;
    readNamespacedPod(podName: string, namespace: string): Promise<V1Pod | undefined>;
    podsExistBySelector(selector: string, namespace?: string): Promise<boolean>;
    getPodPhase(selector: string, namespace?: string): Promise<string>;
    getPodReadyConditionStatus(selector: string, namespace?: string): Promise<string>;
    waitForPodPhase(selector: string, targetPhase: string, namespace?: string, intervalMs?: number, timeoutMs?: number): Promise<void>;
    waitForPodPending(selector: string, namespace?: string, intervalMs?: number, timeoutMs?: number): Promise<void>;
    waitForPodReady(selector: string, namespace?: string, intervalMs?: number, timeoutMs?: number): Promise<void>;
    waitUntilPodIsDeleted(selector: string, namespace?: string, intervalMs?: number, timeoutMs?: number): Promise<void>;
    deletePod(name: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: import("@kubernetes/client-node").V1Status;
    }>;
    waitLatestReplica(deploymentName: string, namespace?: string, intervalMs?: number, timeoutMs?: number): Promise<void>;
    deploymentExist(name?: string, namespace?: string): Promise<boolean>;
    deploymentReady(name?: string, namespace?: string): Promise<boolean>;
    deploymentStopped(name?: string, namespace?: string): Promise<boolean>;
    isDeploymentPaused(name?: string, namespace?: string): Promise<boolean>;
    pauseDeployment(name?: string, namespace?: string): Promise<void>;
    resumeDeployment(name?: string, namespace?: string): Promise<void>;
    scaleDeployment(name: string | undefined, namespace: string | undefined, replicas: number): Promise<void>;
    createDeployment(name: string, image: string, serviceAccount: string, pullPolicy: string, configMapEnvSource: string, namespace: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1Deployment;
    }>;
    createDeploymentFromFile(filePath: string, namespace?: string, containerImage?: string, containerIndex?: number): Promise<{
        response: import("http").IncomingMessage;
        body: V1Deployment;
    }>;
    replaceDeploymentFromFile(filePath: string, namespace?: string, containerImage?: string, containerIndex?: number): Promise<{
        response: import("http").IncomingMessage;
        body: V1Deployment;
    }>;
    deleteAllDeployments(namespace?: string): Promise<void>;
    getDeploymentsBySelector(labelSelector?: string, namespace?: string): Promise<V1DeploymentList>;
    getDeployment(name: string, namespace: string): Promise<V1Deployment | undefined>;
    createPod(name: string, image: string, serviceAccount: string, restartPolicy: string, pullPolicy: string, configMapEnvSource: string, namespace: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1Pod;
    }>;
    compare(body: any, name: string): Promise<boolean>;
    ingressExist(name?: string, namespace?: string): Promise<boolean>;
    deleteAllIngresses(namespace?: string): Promise<void>;
    createCrdFromFile(filePath: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1beta1CustomResourceDefinition;
    }>;
    replaceCrdFromFile(filePath: string, resourceVersion: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1beta1CustomResourceDefinition;
    }>;
    crdExist(name?: string): Promise<boolean | ''>;
    getCrd(name?: string): Promise<V1beta1CustomResourceDefinition>;
    deleteCrd(name?: string): Promise<void>;
    createCheClusterFromFile(filePath: string, flags: any, useDefaultCR: boolean): Promise<any>;
    overrideDefaultValues(yamlCr: any, filePath: string): any;
    cheClusterExist(name?: string, namespace?: string): Promise<boolean>;
    deleteCheCluster(name?: string, namespace?: string): Promise<void>;
    currentContext(): Promise<string>;
    getContext(name: string): Context | null;
    /**
     * Retrieve the default token from the default serviceAccount.
     */
    getDefaultServiceAccountToken(): Promise<string>;
    checkKubeApi(): Promise<void>;
    isOpenShift(): Promise<boolean>;
    getIngressHost(name?: string, namespace?: string): Promise<string>;
    getIngressProtocol(name?: string, namespace?: string): Promise<string>;
    getIngressesBySelector(labelSelector?: string, namespace?: string): Promise<V1beta1IngressList>;
    apiVersionExist(expectedVersion: string): Promise<boolean>;
    getSecret(name?: string, namespace?: string): Promise<V1Secret | undefined>;
    persistentVolumeClaimExist(name?: string, namespace?: string): Promise<boolean>;
    deletePersistentVolumeClaim(name?: string, namespace?: string): Promise<void>;
    getPersistentVolumeClaimsBySelector(labelSelector?: string, namespace?: string): Promise<V1PersistentVolumeClaimList>;
    listNamespace(): Promise<V1NamespaceList>;
    listNamespacedPod(namespace: string, fieldSelector?: string, labelSelector?: string): Promise<V1PodList>;
    /**
     * Reads log by chunk and writes into a file.
     */
    readNamespacedPodLog(pod: string, namespace: string, container: string, filename: string, follow: boolean): Promise<void>;
    /**
     * Forwards port, based on the example
     * https://github.com/kubernetes-client/javascript/blob/master/examples/typescript/port-forward/port-forward.ts
     */
    portForward(podName: string, namespace: string, port: number): Promise<void>;
    /**
     * Checks if message is present and returns error with it
     * or returns error with the specified error if message is not found.
     *
     * @param e k8s error to wrap
     */
    private wrapK8sClientError;
    private safeLoadFromYamlFile;
}
