/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import { V1Deployment } from '@kubernetes/client-node';
import { Command } from '@oclif/command';
import * as Listr from 'listr';
export declare class OperatorTasks {
    operatorServiceAccount: string;
    operatorRole: string;
    operatorClusterRole: string;
    operatorRoleBinding: string;
    operatorClusterRoleBinding: string;
    cheClusterCrd: string;
    operatorName: string;
    operatorCheCluster: string;
    resourcesPath: string;
    /**
     * Returns tasks list which perform preflight platform checks.
     */
    startTasks(flags: any, command: Command): Listr;
    preUpdateTasks(flags: any, command: Command): Listr;
    updateTasks(flags: any, command: Command): Listr;
    /**
     * Returns list of tasks which remove CodeReady Workspaces operator related resources
     */
    deleteTasks(flags: any): ReadonlyArray<Listr.ListrTask>;
    copyCheOperatorResources(templatesDir: string, cacheDir: string): Promise<string>;
    evaluateTemplateOperatorImage(flags: any): Promise<string>;
    retrieveContainerImage(deployment: V1Deployment): string;
}
