/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import { Command } from '@oclif/command';
export default class Start extends Command {
    static description: string;
    static flags: {
        help: import("@oclif/parser/lib/flags").IBooleanFlag<void>;
        chenamespace: import("@oclif/parser/lib/flags").IOptionFlag<string>;
        'listr-renderer': import("@oclif/parser/lib/flags").IOptionFlag<string>;
        'deployment-name': import("@oclif/parser/lib/flags").IOptionFlag<string>;
        cheimage: import("@oclif/parser/lib/flags").IOptionFlag<string>;
        templates: import("@oclif/parser/lib/flags").IOptionFlag<string>;
        'devfile-registry-url': import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
        'plugin-registry-url': import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
        cheboottimeout: import("@oclif/parser/lib/flags").IOptionFlag<string>;
        k8spodwaittimeout: import("@oclif/parser/lib/flags").IOptionFlag<string>;
        k8spodreadytimeout: import("@oclif/parser/lib/flags").IOptionFlag<string>;
        multiuser: import("@oclif/parser/lib/flags").IBooleanFlag<boolean>;
        tls: import("@oclif/parser/lib/flags").IBooleanFlag<boolean>;
        'self-signed-cert': import("@oclif/parser/lib/flags").IBooleanFlag<boolean>;
        platform: import("@oclif/parser/lib/flags").IOptionFlag<string>;
        installer: import("@oclif/parser/lib/flags").IOptionFlag<string>;
        domain: import("@oclif/parser/lib/flags").IOptionFlag<string>;
        debug: import("@oclif/parser/lib/flags").IBooleanFlag<boolean>;
        'os-oauth': import("@oclif/parser/lib/flags").IBooleanFlag<boolean>;
        'che-operator-image': import("@oclif/parser/lib/flags").IOptionFlag<string>;
        'che-operator-cr-yaml': import("@oclif/parser/lib/flags").IOptionFlag<string>;
        'che-operator-cr-patch-yaml': import("@oclif/parser/lib/flags").IOptionFlag<string>;
        directory: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
        'workspace-pvc-storage-class-name': import("@oclif/parser/lib/flags").IOptionFlag<string>;
        'postgres-pvc-storage-class-name': import("@oclif/parser/lib/flags").IOptionFlag<string>;
        'skip-version-check': import("@oclif/parser/lib/flags").IBooleanFlag<boolean>;
    };
    static getTemplatesDir(): string;
    static setPlaformDefaults(flags: any): void;
    checkPlatformCompatibility(flags: any): void;
    run(): Promise<void>;
}
