/*
 * Copyright 2011 Red Hat, Inc. and/or its affiliates.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

package org.infinispan.remoting;

import org.testng.annotations.Test;

import static org.infinispan.config.Configuration.CacheMode.REPL_SYNC;

/**
 * Verifies remote exception handling when state transfer is enabled.
 *
 * @author Galder Zamarreño
 * @since 5.1
 */
@Test(groups = "functional", testName = "remoting.RemoteExceptionHandlingWithStateTransferTest")
public class RemoteExceptionHandlingWithStateTransferTest
      extends TransportSenderExceptionHandlingTest {

   @Override
   protected void createCacheManagers() throws Throwable {
      createClusteredCaches(2, "replSync", getDefaultClusteredConfig(REPL_SYNC)
         .fluent().stateRetrieval().fetchInMemoryState(true)
         .build());
   }

}
