# C# Hot Rod Client #

## Build ##
Build prerequisites:

* C++ HotRod Client (www.infinispan.org/hotrod-clients/)
* CMake 2.8 (www.cmake.org)
* C++03 plus shared_ptr TR1 support.
* SWIG 2.0.x (http://www.swig.org)
* .NET Framework 4.0
* NLog 2.1.0 (http://nlog-project.org/)
* NUnit 2.6.3 (https://launchpad.net/nunitv2)
* IKVM.NET 7.2.4630.5 (http://www.ikvm.net/)

Note: after unpacking IKVM please edit the .exe.config files in <ikvm-root>/bin
and comment-out the "<supportedRuntime version="v2.0.50727"/>" element from all
of them.

Documentation building requirements:
* Doxygen (http://doxygen.org)

Package building requirements:
* WiX (http://wixtoolset.org)

After you install the dependencies please update the PATH environment
variable to include the bin/ directories of CMake, SWIG, Maven, NUnit, IKVM.

Build steps:

    set NLOG_DLL=/path/to/nlog/2.1.0/dll
    
    set HOTRODCPP32_HOME=/path/to/native/32bit/client
    set HOTRODCPP64_HOME=/path/to/native/64bit/client
    
    set HOTROD_SNK=/path/to/key/to/be/generated
    sn.exe -k %HOTROD_SNK%

    set JBOSS_HOME=/path/to/hotrod/standalone/server

By default the build script will run the unit/integrations tests. If
you want to disable them pass ENABLE_{JAVA,CSHARP}_TESTING=false as flags
on the command line:

    build.bat [-DENABLE_JAVA_TESTING=false] [-DENABLE_CSHARP_TESTING=false]

Any additional build.bat arguments you might add will be passed on to cmake
during the build script generation phase.

After the script completes successfully you can find the .msi installer in
the build_windows/ subdirectory.

Support for building the client using Mono (http://www.mono-project.com) will
be coming soon.

## Opening the project in Visual Studio C# 2010 ##

Once the build completes (build.bat runs successfully), it is possible to open
dotnet-client.sln via Visual Studio C# and edit the source code. This solution 
automatically imports two projects: dotnet-client, dotnet-client-tests

The solution can be built from VS and the resulting dll files are in Bin/Release.
These files are only for testing purposes, though.

One way to run C# tests is to start nunit.exe, import the hotrodcs-tests.dll from
Bin/Release and run tests from the GUI.
