package org.infinispan.client.hotrod;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflexConfigurationBuilder {
   private Method addServersMethod;
   private Method buildMethod;
   private Object self;

   public ReflexConfigurationBuilder(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
      Class<?> builderClass = classLoader.loadClass("org.infinispan.client.hotrod.configuration.ConfigurationBuilder");
      addServersMethod = builderClass.getMethod("addServers", new Class[] { String.class });
      buildMethod = builderClass.getMethod("build", new Class[] {});
      Constructor<?> ctor = builderClass.getConstructor(new Class[] {});
      self = ctor.newInstance();
   }

   public ReflexConfigurationBuilder addServers(String servers) throws IllegalAccessException, InvocationTargetException {
        self = addServersMethod.invoke(self, servers);
        return this;
   }
   
   public Object build() throws IllegalAccessException, InvocationTargetException {
        return buildMethod.invoke(self);   
   }
}
