package org.infinispan.cli.interpreter.statement;

import javax.transaction.TransactionManager;

import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.EmptyResult;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.util.logging.LogFactory;

/**
 * Rolls back a running transaction
 *
 * @author Tristan Tarrant
 * @since 5.2
 */
public class RollbackTransactionStatement extends AbstractTransactionStatement {
   private static final Log log = LogFactory.getLog(RollbackTransactionStatement.class, Log.class);

   public RollbackTransactionStatement(final String cacheName) {
      super(cacheName);
   }

   @Override
   public Result execute(Session session) throws StatementException {
      TransactionManager tm = getTransactionManager(session);
      if (tm == null) {
         throw log.noTransactionManager();
      }
      try {
         tm.rollback();
         return EmptyResult.RESULT;
      } catch (Exception e) {
         throw log.cannotRollbackTransaction(e);
      }
   }

}
