/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2011, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.clustering.infinispan.subsystem;

/**
 * @author Tristan Tarrant
 */

public class MetricKeys {
    // shared
    public static final String VERSION = "version";
    // cache container
    public static final String CACHE_MANAGER_STATUS = "cache-manager-status";
    public static final String IS_COORDINATOR = "is-coordinator";
    public static final String COORDINATOR_ADDRESS = "coordinator-address";
    public static final String LOCAL_ADDRESS = "local-address";
    public static final String CLUSTER_AVAILABILITY = "cluster-availability";
    public static final String CLUSTER_NAME = "cluster-name";
    public static final String DEFINED_CACHE_COUNT = "defined-cache-count";
    public static final String DEFINED_CACHE_NAMES = "defined-cache-names";
    public static final String RUNNING_CACHE_COUNT = "running-cache-count";
    public static final String CREATED_CACHE_COUNT = "created-cache-count";
    public static final String MEMBERS = "members";
    public static final String CLUSTER_SIZE = "cluster-size";
    public static final String HEALTH = "health";
    // cache
    public static final String CACHE_STATUS = "cache-status";
    public static final String CACHE_NAME = "cache-name";
    // LockManager
    public static final String NUMBER_OF_LOCKS_AVAILABLE = "number-of-locks-available";
    public static final String NUMBER_OF_LOCKS_HELD = "number-of-locks-held";
    public static final String CONCURRENCY_LEVEL = "concurrency-level";
    // cache management interceptor
    public static final String AVERAGE_READ_TIME = "average-read-time";
    public static final String AVERAGE_WRITE_TIME = "average-write-time";
    public static final String AVERAGE_REMOVE_TIME = "average-remove-time";
    public static final String AVERAGE_READ_TIME_NANOS = "average-read-time-nanos";
    public static final String AVERAGE_WRITE_TIME_NANOS = "average-write-time-nanos";
    public static final String AVERAGE_REMOVE_TIME_NANOS = "average-remove-time-nanos";
    public static final String TIME_SINCE_START = "time-since-start";
    public static final String EVICTIONS = "evictions";
    public static final String HIT_RATIO = "hit-ratio";
    public static final String HITS = "hits";
    public static final String MISSES = "misses";
    public static final String NUMBER_OF_ENTRIES = "number-of-entries";
    public static final String NUMBER_OF_ENTRIES_IN_MEMORY = "number-of-entries-in-memory";
    public static final String DATA_MEMORY_USED = "data-memory-used";
    public static final String OFF_HEAP_MEMORY_USED = "off-heap-memory-used";
    public static final String MINIMUM_REQUIRED_NODES = "minimum-required-nodes";
    public static final String READ_WRITE_RATIO = "read-write-ratio";
    public static final String REMOVE_HITS = "remove-hits";
    public static final String REMOVE_MISSES = "remove-misses";
    public static final String STORES = "stores";
    public static final String TIME_SINCE_RESET = "time-since-reset";
    // transaction manager
    public static final String COMMITS = "commits";
    public static final String PREPARES = "prepares";
    public static final String ROLLBACKS = "rollbacks";
    // invalidation interceptor
    public static final String INVALIDATIONS = "invalidations";
    // passivation interceptor
    public static final String PASSIVATIONS = "passivations";
    // activation interceptor
    public static final String ACTIVATIONS = "activations";
    public static final String CACHE_LOADER_LOADS = "cache-loader-loads";
    public static final String CACHE_LOADER_MISSES = "cache-loader-misses";
    public static final String CACHE_LOADER_STORES = "cache-loader-stores";

    public static final String JOIN_COMPLETE = "join-complete";
    public static final String STATE_TRANSFER_IN_PROGRESS = "state-transfer-in-progress";
    // Rpc manager
    public static final String AVERAGE_REPLICATION_TIME = "average-replication-time";
    public static final String REPLICATION_COUNT = "replication-count";
    public static final String REPLICATION_FAILURES = "replication-failures";
    public static final String SUCCESS_RATIO = "success-ratio";
    public static final String AVG_XSITE_REPLICATION_TIME = "average-xsite-replication-time";
    public static final String MIN_XSITE_REPLICATION_TIME = "minimum-xsite-replication-time";
    public static final String MAX_XSITE_REPLICATION_TIME = "maximum-xsite-replication-time";
    public static final String SYNC_XSITE_COUNT = "sync-xsite-replication-count";
    public static final String ASYNC_XSITE_COUNT = "async-xsite-replication-count";
    public static final String AVG_ASYNC_XSITE_REPLICATION_TIME = "average-async-xsite-replication-time";
    public static final String MIN_ASYNC_XSITE_REPLICATION_TIME = "minimum-async-xsite-replication-time";
    public static final String MAX_ASYNC_XSITE_REPLICATION_TIME = "maximum-async-xsite-replication-time";
    public static final String ASYNC_XSITE_ACKS_COUNT = "async-xsite-acks-count";
    // Backup Metrics
    public static final String SITES_ONLINE = "sites-online";
    public static final String SITES_OFFLINE = "sites-offline";
    public static final String SITES_MIXED = "sites-mixed";
    public static final String SITES_VIEW = "sites-view";
    //Inbound Handler metrics
    public static final String SYNC_XSITE_COUNT_RECEIVED = "sync-xsite-replication-received-count";
    public static final String ASYNC_XSITE_COUNT_RECEIVED = "async-xsite-replication-received-count";
    public static final String ASYNC_XSITE_PENDING_REQUESTS = "async-xsite-pending-requests";
    public static final String ASYNC_XSITE_RUNNING_REQUESTS = "async-xsite-running-requests";
    public static final String ASYNC_XSITE_QUEUE_TIME = "async-xsite-queue-time";
    public static final String ASYNC_XSITE_RUNNING_TIME = "async-xsite-running-time";

    public static final String NUMBER_OF_CPUS = "number-of-cpus";
    public static final String TOTAL_MEMORY_KB = "total-memory";
    public static final String FREE_MEMORY_KB = "free-memory";
    public static final String CLUSTER_HEALTH = "cluster-health";
    public static final String NUMBER_OF_NODES = "number-of-nodes";
    public static final String CACHE_HEALTH = "cache-health";
    public static final String LOG_TAIL = "log-tail";

    // Counter
    public static final String VALUE="value";
    public static final String NUM_OF_OWNERS = "num-owners";
    public static final String RELIABILITY = "reliability";
}
