/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.ConstructorExecutor;
import org.springframework.expression.ConstructorResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypedValue;
import org.springframework.expression.common.ExpressionUtils;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.FormatHelper;
import org.springframework.expression.spel.ast.InlineList;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.TypeCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorReference
extends SpelNodeImpl {
    private boolean isArrayConstructor = false;
    private SpelNodeImpl[] dimensions;
    private volatile ConstructorExecutor cachedExecutor;

    public ConstructorReference(int pos, SpelNodeImpl ... arguments) {
        super(pos, arguments);
        this.isArrayConstructor = false;
    }

    public ConstructorReference(int pos, SpelNodeImpl[] dimensions, SpelNodeImpl ... arguments) {
        super(pos, arguments);
        this.isArrayConstructor = true;
        this.dimensions = dimensions;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        if (this.isArrayConstructor) {
            return this.createArray(state);
        }
        return this.createNewInstance(state);
    }

    private TypedValue createNewInstance(ExpressionState state) throws EvaluationException {
        Object[] arguments = new Object[this.getChildCount() - 1];
        ArrayList<TypeDescriptor> argumentTypes = new ArrayList<TypeDescriptor>(this.getChildCount() - 1);
        int i = 0;
        while (i < arguments.length) {
            Object value;
            TypedValue childValue = this.children[i + 1].getValueInternal(state);
            arguments[i] = value = childValue.getValue();
            argumentTypes.add(TypeDescriptor.forObject((Object)value));
            ++i;
        }
        ConstructorExecutor executorToUse = this.cachedExecutor;
        if (executorToUse != null) {
            try {
                return executorToUse.execute(state.getEvaluationContext(), arguments);
            }
            catch (AccessException ae) {
                Throwable rootCause;
                Throwable causeOfAccessException = ae.getCause();
                Throwable throwable = rootCause = causeOfAccessException == null ? null : causeOfAccessException.getCause();
                if (rootCause != null) {
                    if (rootCause instanceof RuntimeException) {
                        throw (RuntimeException)rootCause;
                    }
                    String typename = (String)this.children[0].getValueInternal(state).getValue();
                    throw new SpelEvaluationException(this.getStartPosition(), rootCause, SpelMessage.CONSTRUCTOR_INVOCATION_PROBLEM, typename, FormatHelper.formatMethodForMessage("", argumentTypes));
                }
                this.cachedExecutor = null;
            }
        }
        String typename = (String)this.children[0].getValueInternal(state).getValue();
        executorToUse = this.findExecutorForConstructor(typename, argumentTypes, state);
        try {
            this.cachedExecutor = executorToUse;
            return executorToUse.execute(state.getEvaluationContext(), arguments);
        }
        catch (AccessException ae) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ae, SpelMessage.CONSTRUCTOR_INVOCATION_PROBLEM, typename, FormatHelper.formatMethodForMessage("", argumentTypes));
        }
    }

    private ConstructorExecutor findExecutorForConstructor(String typename, List<TypeDescriptor> argumentTypes, ExpressionState state) throws SpelEvaluationException {
        EvaluationContext eContext = state.getEvaluationContext();
        List<ConstructorResolver> cResolvers = eContext.getConstructorResolvers();
        if (cResolvers != null) {
            for (ConstructorResolver ctorResolver : cResolvers) {
                try {
                    ConstructorExecutor cEx = ctorResolver.resolve(state.getEvaluationContext(), typename, argumentTypes);
                    if (cEx == null) continue;
                    return cEx;
                }
                catch (AccessException ex) {
                    throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.CONSTRUCTOR_INVOCATION_PROBLEM, typename, FormatHelper.formatMethodForMessage("", argumentTypes));
                }
            }
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.CONSTRUCTOR_NOT_FOUND, typename, FormatHelper.formatMethodForMessage("", argumentTypes));
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        sb.append("new ");
        int index = 0;
        sb.append(this.getChild(index++).toStringAST());
        sb.append("(");
        int i = index;
        while (i < this.getChildCount()) {
            if (i > index) {
                sb.append(",");
            }
            sb.append(this.getChild(i).toStringAST());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    private TypedValue createArray(ExpressionState state) throws EvaluationException {
        Object newArray;
        Object intendedArrayType = this.getChild(0).getValue(state);
        if (!(intendedArrayType instanceof String)) {
            throw new SpelEvaluationException(this.getChild(0).getStartPosition(), SpelMessage.TYPE_NAME_EXPECTED_FOR_ARRAY_CONSTRUCTION, FormatHelper.formatClassNameForMessage(intendedArrayType.getClass()));
        }
        String type = (String)intendedArrayType;
        TypeCode arrayTypeCode = TypeCode.forName(type);
        Class<?> componentType = arrayTypeCode == TypeCode.OBJECT ? state.findType(type) : arrayTypeCode.getType();
        TypeDescriptor td = TypeDescriptor.valueOf(componentType);
        if (!this.hasInitializer()) {
            SpelNodeImpl[] spelNodeImplArray = this.dimensions;
            int n = this.dimensions.length;
            int n2 = 0;
            while (n2 < n) {
                SpelNodeImpl dimension = spelNodeImplArray[n2];
                if (dimension == null) {
                    throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.MISSING_ARRAY_DIMENSION, new Object[0]);
                }
                ++n2;
            }
            TypeConverter typeConverter = state.getEvaluationContext().getTypeConverter();
            if (this.dimensions.length == 1) {
                TypedValue o = this.dimensions[0].getTypedValue(state);
                int arraySize = ExpressionUtils.toInt(typeConverter, o);
                newArray = Array.newInstance(componentType, arraySize);
            } else {
                int[] dims = new int[this.dimensions.length];
                int d = 0;
                while (d < this.dimensions.length) {
                    TypedValue o = this.dimensions[d].getTypedValue(state);
                    dims[d] = ExpressionUtils.toInt(typeConverter, o);
                    ++d;
                }
                newArray = Array.newInstance(componentType, dims);
            }
        } else {
            TypedValue dValue;
            int i;
            if (this.dimensions.length > 1) {
                throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.MULTIDIM_ARRAY_INITIALIZER_NOT_SUPPORTED, new Object[0]);
            }
            TypeConverter typeConverter = state.getEvaluationContext().getTypeConverter();
            InlineList initializer = (InlineList)this.getChild(1);
            if (this.dimensions[0] != null && (i = ExpressionUtils.toInt(typeConverter, dValue = this.dimensions[0].getTypedValue(state))) != initializer.getChildCount()) {
                throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INITIALIZER_LENGTH_INCORRECT, new Object[0]);
            }
            int arraySize = initializer.getChildCount();
            newArray = Array.newInstance(componentType, arraySize);
            if (arrayTypeCode == TypeCode.OBJECT) {
                this.populateReferenceTypeArray(state, newArray, typeConverter, initializer, componentType);
            } else if (arrayTypeCode == TypeCode.INT) {
                this.populateIntArray(state, newArray, typeConverter, initializer);
            } else if (arrayTypeCode == TypeCode.BOOLEAN) {
                this.populateBooleanArray(state, newArray, typeConverter, initializer);
            } else if (arrayTypeCode == TypeCode.CHAR) {
                this.populateCharArray(state, newArray, typeConverter, initializer);
            } else if (arrayTypeCode == TypeCode.LONG) {
                this.populateLongArray(state, newArray, typeConverter, initializer);
            } else if (arrayTypeCode == TypeCode.SHORT) {
                this.populateShortArray(state, newArray, typeConverter, initializer);
            } else if (arrayTypeCode == TypeCode.DOUBLE) {
                this.populateDoubleArray(state, newArray, typeConverter, initializer);
            } else if (arrayTypeCode == TypeCode.FLOAT) {
                this.populateFloatArray(state, newArray, typeConverter, initializer);
            } else if (arrayTypeCode == TypeCode.BYTE) {
                this.populateByteArray(state, newArray, typeConverter, initializer);
            } else {
                throw new IllegalStateException(arrayTypeCode.name());
            }
        }
        return new TypedValue(newArray, td);
    }

    private void populateReferenceTypeArray(ExpressionState state, Object newArray, TypeConverter typeConverter, InlineList initializer, Class<?> componentType) {
        TypeDescriptor toTypeDescriptor = TypeDescriptor.valueOf(componentType);
        Object[] newObjectArray = (Object[])newArray;
        int i = 0;
        while (i < newObjectArray.length) {
            SpelNode elementNode = initializer.getChild(i);
            Object arrayEntry = elementNode.getValue(state);
            newObjectArray[i] = typeConverter.convertValue(arrayEntry, TypeDescriptor.forObject((Object)arrayEntry), toTypeDescriptor);
            ++i;
        }
    }

    private void populateByteArray(ExpressionState state, Object newArray, TypeConverter typeConverter, InlineList initializer) {
        byte[] newByteArray = (byte[])newArray;
        int i = 0;
        while (i < newByteArray.length) {
            TypedValue typedValue = initializer.getChild(i).getTypedValue(state);
            newByteArray[i] = ExpressionUtils.toByte(typeConverter, typedValue);
            ++i;
        }
    }

    private void populateFloatArray(ExpressionState state, Object newArray, TypeConverter typeConverter, InlineList initializer) {
        float[] newFloatArray = (float[])newArray;
        int i = 0;
        while (i < newFloatArray.length) {
            TypedValue typedValue = initializer.getChild(i).getTypedValue(state);
            newFloatArray[i] = ExpressionUtils.toFloat(typeConverter, typedValue);
            ++i;
        }
    }

    private void populateDoubleArray(ExpressionState state, Object newArray, TypeConverter typeConverter, InlineList initializer) {
        double[] newDoubleArray = (double[])newArray;
        int i = 0;
        while (i < newDoubleArray.length) {
            TypedValue typedValue = initializer.getChild(i).getTypedValue(state);
            newDoubleArray[i] = ExpressionUtils.toDouble(typeConverter, typedValue);
            ++i;
        }
    }

    private void populateShortArray(ExpressionState state, Object newArray, TypeConverter typeConverter, InlineList initializer) {
        short[] newShortArray = (short[])newArray;
        int i = 0;
        while (i < newShortArray.length) {
            TypedValue typedValue = initializer.getChild(i).getTypedValue(state);
            newShortArray[i] = ExpressionUtils.toShort(typeConverter, typedValue);
            ++i;
        }
    }

    private void populateLongArray(ExpressionState state, Object newArray, TypeConverter typeConverter, InlineList initializer) {
        long[] newLongArray = (long[])newArray;
        int i = 0;
        while (i < newLongArray.length) {
            TypedValue typedValue = initializer.getChild(i).getTypedValue(state);
            newLongArray[i] = ExpressionUtils.toLong(typeConverter, typedValue);
            ++i;
        }
    }

    private void populateCharArray(ExpressionState state, Object newArray, TypeConverter typeConverter, InlineList initializer) {
        char[] newCharArray = (char[])newArray;
        int i = 0;
        while (i < newCharArray.length) {
            TypedValue typedValue = initializer.getChild(i).getTypedValue(state);
            newCharArray[i] = ExpressionUtils.toChar(typeConverter, typedValue);
            ++i;
        }
    }

    private void populateBooleanArray(ExpressionState state, Object newArray, TypeConverter typeConverter, InlineList initializer) {
        boolean[] newBooleanArray = (boolean[])newArray;
        int i = 0;
        while (i < newBooleanArray.length) {
            TypedValue typedValue = initializer.getChild(i).getTypedValue(state);
            newBooleanArray[i] = ExpressionUtils.toBoolean(typeConverter, typedValue);
            ++i;
        }
    }

    private void populateIntArray(ExpressionState state, Object newArray, TypeConverter typeConverter, InlineList initializer) {
        int[] newIntArray = (int[])newArray;
        int i = 0;
        while (i < newIntArray.length) {
            TypedValue typedValue = initializer.getChild(i).getTypedValue(state);
            newIntArray[i] = ExpressionUtils.toInt(typeConverter, typedValue);
            ++i;
        }
    }

    private boolean hasInitializer() {
        return this.getChildCount() > 1;
    }
}

