/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverAction;
import java.sql.DriverInfo;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;

public class DriverManager {
    private static final CopyOnWriteArrayList<DriverInfo> registeredDrivers = new CopyOnWriteArrayList();
    private static volatile int loginTimeout = 0;
    private static volatile PrintWriter logWriter = null;
    private static volatile PrintStream logStream = null;
    private static final Object logSync = new Object();
    private static final Object lockForInitDrivers = new Object();
    private static volatile boolean driversInitialized;
    private static final String JDBC_DRIVERS_PROPERTY = "jdbc.drivers";
    static final SQLPermission SET_LOG_PERMISSION;
    static final SQLPermission DEREGISTER_DRIVER_PERMISSION;

    private DriverManager() {
    }

    public static PrintWriter getLogWriter() {
        return logWriter;
    }

    public static void setLogWriter(PrintWriter out) {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(SET_LOG_PERMISSION);
        }
        logStream = null;
        logWriter = out;
    }

    @CallerSensitive
    public static Connection getConnection(String url, Properties info) throws SQLException {
        return DriverManager.getConnection(url, info, Reflection.getCallerClass());
    }

    @CallerSensitive
    public static Connection getConnection(String url, String user, String password) throws SQLException {
        Properties info = new Properties();
        if (user != null) {
            info.put("user", user);
        }
        if (password != null) {
            info.put("password", password);
        }
        return DriverManager.getConnection(url, info, Reflection.getCallerClass());
    }

    @CallerSensitive
    public static Connection getConnection(String url) throws SQLException {
        Properties info = new Properties();
        return DriverManager.getConnection(url, info, Reflection.getCallerClass());
    }

    @CallerSensitive
    public static Driver getDriver(String url) throws SQLException {
        DriverManager.println("DriverManager.getDriver(\"" + url + "\")");
        DriverManager.ensureDriversInitialized();
        Class<?> callerClass = Reflection.getCallerClass();
        for (DriverInfo aDriver : registeredDrivers) {
            if (DriverManager.isDriverAllowed(aDriver.driver, callerClass)) {
                try {
                    if (!aDriver.driver.acceptsURL(url)) continue;
                    DriverManager.println("getDriver returning " + aDriver.driver.getClass().getName());
                    return aDriver.driver;
                }
                catch (SQLException sQLException) {
                    continue;
                }
            }
            DriverManager.println("    skipping: " + aDriver.driver.getClass().getName());
        }
        DriverManager.println("getDriver: no suitable driver");
        throw new SQLException("No suitable driver", "08001");
    }

    public static void registerDriver(Driver driver) throws SQLException {
        DriverManager.registerDriver(driver, null);
    }

    public static void registerDriver(Driver driver, DriverAction da) throws SQLException {
        if (driver == null) {
            throw new NullPointerException();
        }
        registeredDrivers.addIfAbsent(new DriverInfo(driver, da));
        DriverManager.println("registerDriver: " + driver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CallerSensitive
    public static void deregisterDriver(Driver driver) throws SQLException {
        if (driver == null) {
            return;
        }
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(DEREGISTER_DRIVER_PERMISSION);
        }
        DriverManager.println("DriverManager.deregisterDriver: " + driver);
        DriverInfo aDriver = new DriverInfo(driver, null);
        Object object = lockForInitDrivers;
        synchronized (object) {
            if (registeredDrivers.contains(aDriver)) {
                if (!DriverManager.isDriverAllowed(driver, Reflection.getCallerClass())) throw new SecurityException();
                DriverInfo di = registeredDrivers.get(registeredDrivers.indexOf(aDriver));
                if (di.action() != null) {
                    di.action().deregister();
                }
                registeredDrivers.remove(aDriver);
            } else {
                DriverManager.println("    couldn't find driver to unload");
            }
            return;
        }
    }

    @CallerSensitive
    public static Enumeration<Driver> getDrivers() {
        DriverManager.ensureDriversInitialized();
        return Collections.enumeration(DriverManager.getDrivers(Reflection.getCallerClass()));
    }

    @CallerSensitive
    public static Stream<Driver> drivers() {
        DriverManager.ensureDriversInitialized();
        return DriverManager.getDrivers(Reflection.getCallerClass()).stream();
    }

    private static List<Driver> getDrivers(Class<?> callerClass) {
        ArrayList<Driver> result = new ArrayList<Driver>();
        for (DriverInfo aDriver : registeredDrivers) {
            if (DriverManager.isDriverAllowed(aDriver.driver, callerClass)) {
                result.add(aDriver.driver);
                continue;
            }
            DriverManager.println("    skipping: " + aDriver.getClass().getName());
        }
        return result;
    }

    public static void setLoginTimeout(int seconds) {
        loginTimeout = seconds;
    }

    public static int getLoginTimeout() {
        return loginTimeout;
    }

    @Deprecated(since="1.2")
    public static void setLogStream(PrintStream out) {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(SET_LOG_PERMISSION);
        }
        logStream = out;
        logWriter = out != null ? new PrintWriter(out) : null;
    }

    @Deprecated(since="1.2")
    public static PrintStream getLogStream() {
        return logStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void println(String message) {
        Object object = logSync;
        synchronized (object) {
            if (logWriter != null) {
                logWriter.println(message);
                logWriter.flush();
            }
        }
    }

    private static boolean isDriverAllowed(Driver driver, Class<?> caller) {
        ClassLoader callerCL = caller != null ? caller.getClassLoader() : null;
        return DriverManager.isDriverAllowed(driver, callerCL);
    }

    private static boolean isDriverAllowed(Driver driver, ClassLoader classLoader) {
        boolean result = false;
        if (driver != null) {
            Class<?> aClass = null;
            try {
                aClass = Class.forName(driver.getClass().getName(), true, classLoader);
            }
            catch (Exception ex) {
                result = false;
            }
            result = aClass == driver.getClass();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureDriversInitialized() {
        if (driversInitialized) {
            return;
        }
        Object object = lockForInitDrivers;
        synchronized (object) {
            String drivers;
            if (driversInitialized) {
                return;
            }
            try {
                drivers = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(DriverManager.JDBC_DRIVERS_PROPERTY);
                    }
                });
            }
            catch (Exception ex) {
                drivers = null;
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ServiceLoader<Driver> loadedDrivers = ServiceLoader.load(Driver.class);
                    Iterator<Driver> driversIterator = loadedDrivers.iterator();
                    try {
                        while (driversIterator.hasNext()) {
                            driversIterator.next();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return null;
                }
            });
            DriverManager.println("DriverManager.initialize: jdbc.drivers = " + drivers);
            if (drivers != null && !drivers.equals("")) {
                String[] driversList = drivers.split(":");
                DriverManager.println("number of Drivers:" + driversList.length);
                for (String aDriver : driversList) {
                    try {
                        DriverManager.println("DriverManager.Initialize: loading " + aDriver);
                        Class.forName(aDriver, true, ClassLoader.getSystemClassLoader());
                    }
                    catch (Exception ex) {
                        DriverManager.println("DriverManager.Initialize: load failed: " + ex);
                    }
                }
            }
            driversInitialized = true;
            DriverManager.println("JDBC DriverManager initialized");
        }
    }

    private static Connection getConnection(String url, Properties info, Class<?> caller) throws SQLException {
        ClassLoader callerCL;
        ClassLoader classLoader = callerCL = caller != null ? caller.getClassLoader() : null;
        if (callerCL == null) {
            callerCL = Thread.currentThread().getContextClassLoader();
        }
        if (url == null) {
            throw new SQLException("The url cannot be null", "08001");
        }
        DriverManager.println("DriverManager.getConnection(\"" + url + "\")");
        DriverManager.ensureDriversInitialized();
        SQLException reason = null;
        for (DriverInfo aDriver : registeredDrivers) {
            if (DriverManager.isDriverAllowed(aDriver.driver, callerCL)) {
                try {
                    DriverManager.println("    trying " + aDriver.driver.getClass().getName());
                    Connection con = aDriver.driver.connect(url, info);
                    if (con == null) continue;
                    DriverManager.println("getConnection returning " + aDriver.driver.getClass().getName());
                    return con;
                }
                catch (SQLException ex) {
                    if (reason != null) continue;
                    reason = ex;
                    continue;
                }
            }
            DriverManager.println("    skipping: " + aDriver.getClass().getName());
        }
        if (reason != null) {
            DriverManager.println("getConnection failed: " + reason);
            throw reason;
        }
        DriverManager.println("getConnection: no suitable driver found for " + url);
        throw new SQLException("No suitable driver found for " + url, "08001");
    }

    static {
        SET_LOG_PERMISSION = new SQLPermission("setLog");
        DEREGISTER_DRIVER_PERMISSION = new SQLPermission("deregisterDriver");
    }
}

