/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class IFixUtils {
    public static ParsedIFix parse(File fixFile) throws ParserConfigurationException, IOException, SAXException {
        String id = null;
        ArrayList<String> fileNames = new ArrayList<String>();
        ArrayList<String> apars = new ArrayList<String>();
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document d = db.parse(fixFile);
        NodeList nl = d.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element) || !n.getNodeName().equalsIgnoreCase("fix")) continue;
            id = ((Element)n).getAttribute("id");
            NodeList fixElements = n.getChildNodes();
            for (int j = 0; j < fixElements.getLength(); ++j) {
                int k;
                Node subNode = fixElements.item(j);
                if (subNode.getNodeName().equalsIgnoreCase("updates")) {
                    NodeList fileNodes = subNode.getChildNodes();
                    for (k = 0; k < fileNodes.getLength(); ++k) {
                        Node fileNode = fileNodes.item(k);
                        if (!(fileNode instanceof Element)) continue;
                        fileNames.add(((Element)fileNode).getAttribute("id"));
                    }
                    continue;
                }
                if (!subNode.getNodeName().equalsIgnoreCase("resolves")) continue;
                NodeList problemNodes = subNode.getChildNodes();
                for (k = 0; k < problemNodes.getLength(); ++k) {
                    Node problemNode = problemNodes.item(k);
                    if (!(problemNode instanceof Element)) continue;
                    apars.add(((Element)problemNode).getAttribute("displayId"));
                }
            }
        }
        ParsedIFix result = new ParsedIFix(id, fileNames, apars);
        return result;
    }

    static List listIFixesThatMustBeReapplied(File wlpDir, List extractedFiles) throws ParserConfigurationException, IOException, SAXException {
        Set fixFiles = IFixUtils.filterSupersededIFixXmls(wlpDir);
        ArrayList<String> result = new ArrayList<String>();
        if (fixFiles != null) {
            Iterator iter = fixFiles.iterator();
            block0: while (iter.hasNext()) {
                File f = (File)iter.next();
                ParsedIFix iFix = IFixUtils.parse(f);
                Iterator j = iFix.fixedFiles.iterator();
                while (j.hasNext()) {
                    String fixedFile = (String)j.next();
                    Iterator k = extractedFiles.iterator();
                    while (k.hasNext()) {
                        String extractedFile = (String)k.next();
                        if (!IFixUtils.matchesIFixedFile(extractedFile, fixedFile)) continue;
                        result.add(iFix.id);
                        continue block0;
                    }
                }
            }
        }
        return result;
    }

    private static Set getAllFixXMLs(File wlpDir) {
        HashSet<File> result = new HashSet<File>();
        File libFixes = new File(wlpDir, "lib/fixes");
        File[] xmlFiles = libFixes.listFiles();
        if (xmlFiles != null && xmlFiles.length > 0) {
            result.addAll(Arrays.asList(xmlFiles));
        }
        return result;
    }

    public static Set filterSupersededIFixXmls(File wlpInstallationDirectory) throws ParserConfigurationException, IOException, SAXException {
        Set ifixXMLs = IFixUtils.getAllFixXMLs(wlpInstallationDirectory);
        HashSet<File> validIFixXMLs = new HashSet<File>();
        Iterator iter = ifixXMLs.iterator();
        while (iter.hasNext()) {
            boolean superseded = false;
            File f1 = (File)iter.next();
            ParsedIFix iFix1 = IFixUtils.parse(f1);
            Iterator iter2 = ifixXMLs.iterator();
            while (iter2.hasNext()) {
                File f2 = (File)iter2.next();
                ParsedIFix iFix2 = IFixUtils.parse(f2);
                if (iFix1.id.equals(iFix2.id) || !IFixUtils.isSupersededBy(iFix1.apars, iFix2.apars)) continue;
                superseded = true;
            }
            if (superseded) continue;
            validIFixXMLs.add(f1);
        }
        return validIFixXMLs;
    }

    private static boolean isSupersededBy(List apars1, List apars2) {
        boolean result = true;
        Iterator iter1 = apars1.iterator();
        while (iter1.hasNext()) {
            boolean currAparMatch = false;
            String currApar1 = (String)iter1.next();
            Iterator iter2 = apars2.iterator();
            while (iter2.hasNext()) {
                String currApar2 = (String)iter2.next();
                if (!currApar1.equals(currApar2)) continue;
                currAparMatch = true;
            }
            if (currAparMatch) continue;
            result = false;
        }
        return result;
    }

    static boolean matchesIFixedFile(String extractedFile, String iFixedFile) {
        if (extractedFile.endsWith(iFixedFile)) {
            return true;
        }
        if (!extractedFile.regionMatches(true, extractedFile.length() - 4, ".jar", 0, 4)) {
            return false;
        }
        String extractedBundle = extractedFile.substring(0, extractedFile.lastIndexOf("."));
        String extractedDir = extractedBundle.substring(0, extractedBundle.lastIndexOf("/"));
        String fixedDir = iFixedFile.substring(0, iFixedFile.lastIndexOf("/"));
        String extractedFileName = extractedBundle.substring(extractedBundle.lastIndexOf("/") + 1);
        String fixedFileName = iFixedFile.substring(iFixedFile.lastIndexOf("/") + 1);
        return extractedDir.endsWith(fixedDir) && fixedFileName.startsWith(extractedFileName);
    }

    public static class ParsedIFix {
        String id;
        List fixedFiles;
        List apars;

        public ParsedIFix(String id, List fileNames, List aparNames) {
            this.id = id;
            this.fixedFiles = fileNames;
            this.apars = aparNames;
        }
    }
}

