/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import wiremock.com.google.common.base.Function;
import wiremock.com.google.common.base.Optional;
import wiremock.com.google.common.base.Predicate;
import wiremock.com.google.common.collect.ImmutableList;
import wiremock.com.google.common.collect.Iterables;

public class InMemoryRequestJournal
implements RequestJournal {
    private final Queue<ServeEvent> serveEvents = new ConcurrentLinkedQueue<ServeEvent>();
    private final Optional<Integer> maxEntries;

    public InMemoryRequestJournal(Optional<Integer> maxEntries) {
        if (maxEntries.isPresent() && maxEntries.get() < 0) {
            throw new IllegalArgumentException("Maximum number of entries of journal must be greater than zero");
        }
        this.maxEntries = maxEntries;
    }

    @Override
    public int countRequestsMatching(RequestPattern requestPattern) {
        return Iterables.size(Iterables.filter(this.getRequests(), RequestPattern.thatMatch(requestPattern)));
    }

    @Override
    public List<LoggedRequest> getRequestsMatching(RequestPattern requestPattern) {
        return ImmutableList.copyOf(Iterables.filter(this.getRequests(), RequestPattern.thatMatch(requestPattern)));
    }

    private Predicate<Request> matchedBy(final RequestPattern requestPattern) {
        return new Predicate<Request>(){

            @Override
            public boolean apply(Request input) {
                return requestPattern.isMatchedBy(input, Collections.emptyMap());
            }
        };
    }

    @Override
    public void requestReceived(ServeEvent serveEvent) {
        this.serveEvents.add(serveEvent);
        this.removeOldEntries();
    }

    @Override
    public List<ServeEvent> getAllServeEvents() {
        return ImmutableList.copyOf(this.serveEvents).reverse();
    }

    @Override
    public Optional<ServeEvent> getServeEvent(final UUID id) {
        return Iterables.tryFind(this.serveEvents, new Predicate<ServeEvent>(){

            @Override
            public boolean apply(ServeEvent input) {
                return input.getId().equals(id);
            }
        });
    }

    @Override
    public void reset() {
        this.serveEvents.clear();
    }

    private Iterable<LoggedRequest> getRequests() {
        return Iterables.transform(this.serveEvents, new Function<ServeEvent, LoggedRequest>(){

            @Override
            public LoggedRequest apply(ServeEvent input) {
                return input.getRequest();
            }
        });
    }

    private void removeOldEntries() {
        if (this.maxEntries.isPresent()) {
            while (this.serveEvents.size() > this.maxEntries.get()) {
                this.serveEvents.poll();
            }
        }
    }
}

