/*******************************************************************************
 * Copyright (c) 2017 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.security.javaeesec.cdi.extensions;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

import com.ibm.ws.security.authorization.AuthorizationService;
import com.ibm.ws.security.intfc.SubjectManagerService;

/**
 *
 */
@Component(service = { SecurityContextHelper.class },
           configurationPolicy = ConfigurationPolicy.IGNORE,
           immediate = true,
           property = { "service.vendor=IBM" })
public class SecurityContextHelper {

    private static AuthorizationService authorizationService;
    private static SubjectManagerService smService;

    @Reference
    protected void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    protected void unsetAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = null;
    }

    public static AuthorizationService getAuthorizationService() {
        return authorizationService;
    }

    @Reference
    public void setSubjectManagerService(SubjectManagerService smService) {
        this.smService = smService;
    }

    public void unsetSubjectManagerService(SubjectManagerService smService) {
        this.smService = null;
    }

    public static SubjectManagerService getSubjectManagerService() {
        return smService;
    }
}
