CREATE TABLE CUSTOMER (
		CUSTID NVARCHAR(250) NOT NULL,
		CUSTPWD NVARCHAR(250) NULL,
		CUSTNAME NVARCHAR(250) NULL,
		NUMINVOICESCREATED INTEGER NOT NULL,
		NUMINVOICESCOMPLETED INTEGER NOT NULL
	)
GO

CREATE TABLE CUSTOMERINFO (
		CUSTID NVARCHAR(250) NOT NULL,
		ADDRESS1 NVARCHAR(250) NULL,
		ADDRESS2 NVARCHAR(250) NULL,
		PHONE NVARCHAR(250) NULL,
		EMAIL NVARCHAR(250) NULL,
		CCNUM NVARCHAR(250) NULL
	)
GO

CREATE TABLE CATEGORY (
		CATEGORYNAME NVARCHAR(250) NOT NULL,
		NUMITEMSINCATEGORY INTEGER NOT NULL,
		CATEGORYDESCRIPTION NVARCHAR(250) NULL
	)
GO

CREATE TABLE INVENTORY (
		CATEGORYNAME NVARCHAR(250) NULL,
		ITEMID NVARCHAR(250) NOT NULL,
		MFGNAME NVARCHAR(250) NULL,
		UNITPRICE REAL NOT NULL,
		INVENTORYSOLD INTEGER NOT NULL,
		DESCRIPTION NVARCHAR(250) NULL,
		PIC VARBINARY(1000) NULL
	)
GO

CREATE TABLE MFGCATEGORY (
		MFGNAME NVARCHAR(250) NOT NULL,
		CATEGORY_CATEGORYNAME NVARCHAR(250) NOT NULL
	)
GO

CREATE TABLE STORECREDIT (
		AMOUNT REAL NOT NULL,
		CUSTID NVARCHAR(250) NOT NULL,
		TIME1 DATETIME NOT NULL
	)
GO

CREATE TABLE SETTINGS (
		ID INTEGER NOT NULL,
		NUMSUBACCOUNTS INTEGER NOT NULL,
		NUMCATEGORIES INTEGER NOT NULL,
		NUMMFGCATEGORIES INTEGER NOT NULL,
		NUMITEMSPERMFG INTEGER NOT NULL,
		NUMCUSTOMERS INTEGER NOT NULL,
		WSATENABLED TINYINT NOT NULL,
		WSNENABLED TINYINT NOT NULL,
		SDOENABLED TINYINT NOT NULL,
		WSNVARIABLES NVARCHAR(250) NULL
	)
GO

ALTER TABLE CUSTOMER ADD CONSTRAINT PK_CUSTOMER PRIMARY KEY (CUSTID)
GO

ALTER TABLE CUSTOMERINFO ADD CONSTRAINT PK_CUSTOMERINFO PRIMARY KEY (CUSTID)
GO

ALTER TABLE CATEGORY ADD CONSTRAINT PK_CATEGORY PRIMARY KEY (CATEGORYNAME)
GO

ALTER TABLE INVENTORY ADD CONSTRAINT PK_INVENTORY PRIMARY KEY (ITEMID)
GO

ALTER TABLE MFGCATEGORY ADD CONSTRAINT PK_MFGCATEGORY PRIMARY KEY (MFGNAME, CATEGORY_CATEGORYNAME)
GO

ALTER TABLE STORECREDIT ADD CONSTRAINT PK_STORECREDIT PRIMARY KEY (CUSTID, TIME1)
GO

ALTER TABLE SETTINGS ADD CONSTRAINT PK_SETTINGS PRIMARY KEY (ID)
GO

