CREATE TABLE CUSTOMER (
		CUSTID VARCHAR2(250) NOT NULL,
		CUSTPWD VARCHAR2(250),
		CUSTNAME VARCHAR2(250),
		NUMINVOICESCREATED INT NOT NULL,
		NUMINVOICESCOMPLETED INT NOT NULL
	)
	LOGGING;

CREATE TABLE CUSTOMERINFO (
		CUSTID VARCHAR2(250) NOT NULL,
		ADDRESS1 VARCHAR2(250),
		ADDRESS2 VARCHAR2(250),
		PHONE VARCHAR2(250),
		EMAIL VARCHAR2(250),
		CCNUM VARCHAR2(250)
	)
	LOGGING;

CREATE TABLE CATEGORY (
		CATEGORYNAME VARCHAR2(250) NOT NULL,
		NUMITEMSINCATEGORY INT NOT NULL,
		CATEGORYDESCRIPTION VARCHAR2(250)
	)
	LOGGING;

CREATE TABLE INVENTORY (
		CATEGORYNAME VARCHAR2(250),
		ITEMID VARCHAR2(250) NOT NULL,
		MFGNAME VARCHAR2(250),
		UNITPRICE FLOAT(23) NOT NULL,
		INVENTORYSOLD INT NOT NULL,
		DESCRIPTION VARCHAR2(250),
		PIC LONG RAW
	)
	LOGGING;

CREATE TABLE MFGCATEGORY (
		MFGNAME VARCHAR2(250) NOT NULL,
		CATEGORY_CATEGORYNAME VARCHAR2(250) NOT NULL
	)
	LOGGING;

CREATE TABLE STORECREDIT (
		AMOUNT FLOAT(23) NOT NULL,
		CUSTID VARCHAR2(250) NOT NULL,
		TIME1 TIMESTAMP(6) NOT NULL
	)
	LOGGING;

CREATE TABLE SETTINGS (
		ID INT NOT NULL,
		NUMSUBACCOUNTS INT NOT NULL,
		NUMCATEGORIES INT NOT NULL,
		NUMMFGCATEGORIES INT NOT NULL,
		NUMITEMSPERMFG INT NOT NULL,
		NUMCUSTOMERS INT NOT NULL,
		WSATENABLED SMALLINT NOT NULL,
		WSNENABLED SMALLINT NOT NULL,
		SDOENABLED SMALLINT NOT NULL,
		WSNVARIABLES VARCHAR2(250)
	)
	LOGGING;

ALTER TABLE CUSTOMER ADD CONSTRAINT PK_CUSTOMER PRIMARY KEY (CUSTID);

ALTER TABLE CUSTOMERINFO ADD CONSTRAINT PK_CUSTOMERINFO PRIMARY KEY (CUSTID);

ALTER TABLE CATEGORY ADD CONSTRAINT PK_CATEGORY PRIMARY KEY (CATEGORYNAME);

ALTER TABLE INVENTORY ADD CONSTRAINT PK_INVENTORY PRIMARY KEY (ITEMID);

ALTER TABLE MFGCATEGORY ADD CONSTRAINT PK_MFGCATEGORY PRIMARY KEY (MFGNAME, CATEGORY_CATEGORYNAME);

ALTER TABLE STORECREDIT ADD CONSTRAINT PK_STORECREDIT PRIMARY KEY (CUSTID, TIME1);

ALTER TABLE SETTINGS ADD CONSTRAINT PK_SETTINGS PRIMARY KEY (ID);

