/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.content.sync;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.DownloadMode;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.PackageVersionContentSource;
import org.rhq.core.domain.content.PackageVersionContentSourcePK;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoSyncResults;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.plugin.pc.content.ContentProvider;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetails;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetailsKey;
import org.rhq.enterprise.server.plugin.pc.content.PackageSource;
import org.rhq.enterprise.server.plugin.pc.content.PackageSyncReport;
import org.rhq.enterprise.server.plugin.pc.content.SyncException;
import org.rhq.enterprise.server.plugin.pc.content.SyncProgressWeight;
import org.rhq.enterprise.server.plugin.pc.content.SyncTracker;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageSourceSynchronizer {
    private final Log log = LogFactory.getLog(this.getClass());
    private ContentSourceManagerLocal contentSourceManager;
    private RepoManagerLocal repoManager;
    private SubjectManagerLocal subjectManager;
    private Repo repo;
    private ContentSource source;
    private ContentProvider provider;

    public PackageSourceSynchronizer(Repo repo, ContentSource source, ContentProvider provider) {
        this.repo = repo;
        this.source = source;
        this.provider = provider;
        this.contentSourceManager = LookupUtil.getContentSourceManager();
        this.subjectManager = LookupUtil.getSubjectManager();
        this.repoManager = LookupUtil.getRepoManagerLocal();
    }

    public SyncTracker synchronizePackageMetadata(SyncTracker tracker) throws SyncException, InterruptedException {
        if (!(this.provider instanceof PackageSource)) {
            return tracker;
        }
        PackageSource packageSource = (PackageSource)((Object)this.provider);
        long start = System.currentTimeMillis();
        Subject overlord = this.subjectManager.getOverlord();
        List<PackageVersionContentSource> existingPVCS = this.contentSourceManager.getPackageVersionsFromContentSourceForRepo(overlord, this.source.getId(), this.repo.getId());
        int existingCount = existingPVCS.size();
        HashMap<ContentProviderPackageDetailsKey, PackageVersionContentSource> keyPVCSMap = new HashMap<ContentProviderPackageDetailsKey, PackageVersionContentSource>(existingCount);
        HashSet<ContentProviderPackageDetails> allDetails = new HashSet<ContentProviderPackageDetails>(existingCount);
        this.translateDomainToDto(existingPVCS, allDetails, keyPVCSMap);
        this.log.info((Object)("Synchronize Packages: [" + this.source.getName() + "]: loaded existing list of size=[" + existingCount + "] (" + (System.currentTimeMillis() - start) + ")ms"));
        start = System.currentTimeMillis();
        PackageSyncReport report = new PackageSyncReport();
        packageSource.synchronizePackages(this.repo.getName(), report, allDetails);
        tracker.setPackageSyncCount(report.getNewPackages().size() + report.getUpdatedPackages().size());
        this.log.info((Object)("Synchronize Packages: [" + this.source.getName() + "]: got sync report from adapter=[" + report + "] (" + (System.currentTimeMillis() - start) + ")ms.  Have: " + tracker.getPackageSyncCount() + " packages to sync"));
        start = System.currentTimeMillis();
        RepoSyncResults syncResults = this.contentSourceManager.mergePackageSyncReport(this.source, this.repo, report, keyPVCSMap, tracker.getRepoSyncResults());
        tracker.setRepoSyncResults(syncResults);
        this.log.info((Object)("Synchronize Packages: [" + this.source.getName() + "]: merged sync report=(" + (System.currentTimeMillis() - start) + ")ms"));
        return tracker;
    }

    public SyncTracker synchronizePackageBits(SyncTracker tracker, ContentProvider provider) throws InterruptedException, SyncException {
        SyncProgressWeight sw = provider.getSyncProgressWeight();
        if (!(provider instanceof PackageSource)) {
            return tracker;
        }
        if (this.source.getDownloadMode() == DownloadMode.NEVER) {
            String msg = "Download mode of NEVER for source [" + this.source.getName() + "], skipping " + "package bits sync for repo [" + this.repo.getName() + "]";
            this.log.info((Object)msg);
            tracker.getRepoSyncResults().appendResults(msg);
            tracker.setRepoSyncResults(this.repoManager.mergeRepoSyncResults(tracker.getRepoSyncResults()));
            tracker.getProgressWatcher().finishWork(sw.getPackageBitsWeight() * tracker.getPackageSyncCount());
            return tracker;
        }
        if (this.source.isLazyLoad()) {
            String msg = "Lazy load enabled for source [" + this.source.getName() + "], skipping " + "package bits sync for repo [" + this.repo.getName() + "]";
            this.log.info((Object)msg);
            tracker.getRepoSyncResults().appendResults(msg);
            tracker.setRepoSyncResults(this.repoManager.mergeRepoSyncResults(tracker.getRepoSyncResults()));
            tracker.getProgressWatcher().finishWork(sw.getPackageBitsWeight() * tracker.getPackageSyncCount());
            return tracker;
        }
        long start = System.currentTimeMillis();
        PageControl pc = PageControl.getUnlimitedInstance();
        Subject overlord = this.subjectManager.getOverlord();
        PageList<PackageVersionContentSource> packageVersionContentSources = this.contentSourceManager.getUnloadedPackageVersionsFromContentSourceInRepo(overlord, this.source.getId(), this.repo.getId(), pc);
        String msg = "Synchronize Package Bits: [" + this.source.getName() + "], repo [" + this.repo.getName() + "]: loaded package list for sync (" + (System.currentTimeMillis() - start) + ")ms";
        this.log.info((Object)msg);
        tracker.getRepoSyncResults().appendResults(msg);
        tracker.setRepoSyncResults(this.repoManager.mergeRepoSyncResults(tracker.getRepoSyncResults()));
        for (PackageVersionContentSource item : packageVersionContentSources) {
            PackageVersionContentSourcePK pk = item.getPackageVersionContentSourcePK();
            try {
                this.log.info((Object)("Downloading package version [" + pk.getPackageVersion() + "] located at [" + item.getLocation() + "]" + "] from [" + pk.getContentSource() + "]..."));
                tracker.getRepoSyncResults().appendResults("Downloading package version [" + pk.getPackageVersion() + "] located at [" + item.getLocation() + "]");
                tracker.setRepoSyncResults(this.repoManager.mergeRepoSyncResults(tracker.getRepoSyncResults()));
                overlord = this.subjectManager.getOverlord();
                this.contentSourceManager.downloadPackageBits(overlord, item);
                tracker.getProgressWatcher().finishWork(sw.getPackageBitsWeight() * 1);
                tracker.getRepoSyncResults().setPercentComplete(new Long(tracker.getProgressWatcher().getPercentComplete()));
                tracker.setRepoSyncResults(this.repoManager.mergeRepoSyncResults(tracker.getRepoSyncResults()));
            }
            catch (Exception e) {
                String errorMsg = "Failed to load package bits for package version [" + pk.getPackageVersion() + "] from content source [" + pk.getContentSource() + "] at location [" + item.getLocation() + "]." + "No more packages will be downloaded for this content source.";
                throw new SyncException(errorMsg, e);
            }
        }
        this.log.info((Object)("All package bits for content source [" + this.source.getName() + "] have been downloaded." + "The downloads started at [" + new Date(start) + "] and ended at [" + new Date() + "]"));
        return tracker;
    }

    private void translateDomainToDto(List<PackageVersionContentSource> existingPVCS, Set<ContentProviderPackageDetails> allDetails, Map<ContentProviderPackageDetailsKey, PackageVersionContentSource> keyPVCSMap) {
        for (PackageVersionContentSource pvcs : existingPVCS) {
            PackageVersion pv = pvcs.getPackageVersionContentSourcePK().getPackageVersion();
            Package p = pv.getGeneralPackage();
            ResourceType rt = p.getPackageType().getResourceType();
            ContentProviderPackageDetailsKey key = new ContentProviderPackageDetailsKey(p.getName(), pv.getVersion(), p.getPackageType().getName(), pv.getArchitecture().getName(), rt.getName(), rt.getPlugin());
            ContentProviderPackageDetails details = new ContentProviderPackageDetails(key);
            details.setClassification(pv.getGeneralPackage().getClassification());
            details.setDisplayName(pv.getDisplayName());
            details.setDisplayVersion(pv.getDisplayVersion());
            details.setExtraProperties(pv.getExtraProperties());
            details.setFileCreatedDate(pv.getFileCreatedDate());
            details.setFileName(pv.getFileName());
            details.setFileSize(pv.getFileSize());
            details.setLicenseName(pv.getLicenseName());
            details.setLicenseVersion(pv.getLicenseVersion());
            details.setLocation(pvcs.getLocation());
            details.setLongDescription(pv.getLongDescription());
            details.setMD5(pv.getMD5());
            details.setMetadata(pv.getMetadata());
            details.setSHA256(pv.getSHA256());
            details.setShortDescription(pv.getShortDescription());
            allDetails.add(details);
            keyPVCSMap.put(key, pvcs);
        }
    }
}

