/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.IgnoreDependency;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.common.composite.IntegerOptionItem;
import org.rhq.core.domain.criteria.AlertDefinitionCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.NumericType;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerRemote;
import org.rhq.enterprise.server.alert.AlertDefinitionUpdateException;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.alert.InvalidAlertDefinitionException;
import org.rhq.enterprise.server.alert.engine.AlertDefinitionEvent;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.cloud.StatusManagerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class AlertDefinitionManagerBean
implements AlertDefinitionManagerLocal,
AlertDefinitionManagerRemote {
    private static final Log LOG = LogFactory.getLog(AlertDefinitionManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private AlertDefinitionManagerLocal alertDefinitionManager;
    @EJB
    @IgnoreDependency
    private AlertNotificationManagerLocal alertNotificationManager;
    @EJB
    private StatusManagerLocal agentStatusManager;

    private boolean checkViewPermission(Subject subject, AlertDefinition alertDefinition) {
        if (alertDefinition.getResourceType() != null) {
            return this.authorizationManager.hasGlobalPermission(subject, Permission.MANAGE_SETTINGS);
        }
        if (alertDefinition.getResourceGroup() != null) {
            return this.authorizationManager.canViewGroup(subject, alertDefinition.getResourceGroup().getId());
        }
        return this.authorizationManager.canViewResource(subject, alertDefinition.getResource().getId());
    }

    private boolean checkPermission(Subject subject, AlertDefinition alertDefinition) {
        if (this.authorizationManager.isOverlord(subject)) {
            return true;
        }
        if (alertDefinition.getResourceType() != null) {
            return this.authorizationManager.hasGlobalPermission(subject, Permission.MANAGE_SETTINGS);
        }
        if (alertDefinition.getResourceGroup() != null) {
            return this.authorizationManager.hasGroupPermission(subject, Permission.MANAGE_ALERTS, alertDefinition.getResourceGroup().getId());
        }
        return this.authorizationManager.hasResourcePermission(subject, Permission.MANAGE_ALERTS, alertDefinition.getResource().getId());
    }

    @Override
    public PageList<AlertDefinition> findAlertDefinitions(Subject subject, int resourceId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("ctime", PageOrdering.DESC);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"AlertDefinition.findByResource");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"AlertDefinition.findByResource", (PageControl)pageControl);
        queryCount.setParameter("id", (Object)resourceId);
        query.setParameter("id", (Object)resourceId);
        long totalCount = (Long)queryCount.getSingleResult();
        List list = query.getResultList();
        return new PageList((Collection)list, (int)totalCount, pageControl);
    }

    @Override
    public AlertDefinition getAlertDefinitionById(Subject subject, int alertDefinitionId) {
        AlertDefinition alertDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)alertDefinitionId);
        if (alertDefinition == null) {
            return null;
        }
        if (!this.checkViewPermission(subject, alertDefinition)) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to view alertDefinition[id=" + alertDefinitionId + "] for resource[id=" + alertDefinition.getResource().getId() + "]");
        }
        alertDefinition.getConditions().size();
        for (AlertCondition cond : alertDefinition.getConditions()) {
            if (cond.getMeasurementDefinition() == null) continue;
            cond.getMeasurementDefinition().getId();
        }
        for (AlertNotification notification : alertDefinition.getAlertNotifications()) {
            notification.getConfiguration().getProperties().size();
            if (notification.getExtraConfiguration() == null) continue;
            notification.getExtraConfiguration().getProperties().size();
        }
        return alertDefinition;
    }

    @Override
    public List<IntegerOptionItem> findAlertDefinitionOptionItemsForResource(Subject subject, int resourceId) {
        PageControl pageControl = PageControl.getUnlimitedInstance();
        pageControl.initDefaultOrderingField("ad.name", PageOrdering.ASC);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"AlertDefinition.findOptionItemsByResource", (PageControl)pageControl);
        query.setParameter("resourceId", (Object)resourceId);
        List results = query.getResultList();
        return results;
    }

    @Override
    public List<IntegerOptionItem> findAlertDefinitionOptionItemsForGroup(Subject subject, int groupId) {
        PageControl pageControl = PageControl.getUnlimitedInstance();
        pageControl.initDefaultOrderingField("ad.name", PageOrdering.ASC);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"AlertDefinition.findOptionItemsByGroup", (PageControl)pageControl);
        query.setParameter("groupId", (Object)groupId);
        List results = query.getResultList();
        return results;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public int createAlertDefinition(Subject subject, AlertDefinition alertDefinition, Integer resourceId) throws InvalidAlertDefinitionException {
        this.checkAlertDefinition(alertDefinition, resourceId);
        if (resourceId != null) {
            alertDefinition.setResource(new Resource(resourceId.intValue()));
        }
        if (!this.checkPermission(subject, alertDefinition)) {
            if (alertDefinition.getResourceType() != null) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to create alert templates for type [" + alertDefinition.getResourceType() + "]");
            }
            if (alertDefinition.getResourceGroup() != null) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to create alert definitions for group [" + alertDefinition.getResourceGroup() + "]");
            }
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to create alert definitions for resource [" + alertDefinition.getResource() + "]");
        }
        if (alertDefinition.getConditions().size() == 1) {
            alertDefinition.setConditionExpression(BooleanExpression.ANY);
        }
        this.fixRecoveryId(alertDefinition);
        this.entityManager.persist((Object)alertDefinition);
        boolean addToCache = false;
        if (resourceId != null && alertDefinition.getEnabled()) {
            if (alertDefinition.getRecoveryId() != 0) {
                AlertDefinition toBeRecoveredDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)alertDefinition.getRecoveryId());
                if (!toBeRecoveredDefinition.getEnabled()) {
                    addToCache = true;
                }
            } else {
                addToCache = true;
            }
        }
        if (addToCache) {
            this.notifyAlertConditionCacheManager("createAlertDefinition", alertDefinition, AlertDefinitionEvent.CREATED);
        }
        return alertDefinition.getId();
    }

    private void fixRecoveryId(AlertDefinition definition) {
        try {
            if (definition.getParentId() != 0 && definition.getRecoveryId() != 0) {
                String findCorrectRecoveryId = " SELECT toBeRecovered.id    FROM AlertDefinition toBeRecovered   WHERE toBeRecovered.resource.id = :resourceId     AND toBeRecovered.parentId = :parentId ";
                Query fixRecoveryIdQuery = this.entityManager.createQuery(findCorrectRecoveryId);
                fixRecoveryIdQuery.setParameter("resourceId", (Object)definition.getResource().getId());
                fixRecoveryIdQuery.setParameter("parentId", (Object)definition.getRecoveryId());
                Integer correctRecoveryId = (Integer)fixRecoveryIdQuery.getSingleResult();
                definition.setRecoveryId(correctRecoveryId);
            } else if (definition.getGroupAlertDefinition() != null && definition.getRecoveryId() != 0) {
                String findCorrectRecoveryId = " SELECT toBeRecovered.id    FROM AlertDefinition toBeRecovered   WHERE toBeRecovered.resource.id = :resourceId     AND toBeRecovered.groupAlertDefinition.id = :groupAlertDefinitionId ";
                Query fixRecoveryIdQuery = this.entityManager.createQuery(findCorrectRecoveryId);
                fixRecoveryIdQuery.setParameter("resourceId", (Object)definition.getResource().getId());
                fixRecoveryIdQuery.setParameter("groupAlertDefinitionId", (Object)definition.getRecoveryId());
                Integer correctRecoveryId = (Integer)fixRecoveryIdQuery.getSingleResult();
                definition.setRecoveryId(correctRecoveryId);
            }
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }

    @Override
    public int removeAlertDefinitions(Subject subject, Integer[] alertDefinitionIds) {
        int modifiedCount = 0;
        boolean isResourceLevel = false;
        Integer[] arr$ = alertDefinitionIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int alertDefId = arr$[i$];
            AlertDefinition alertDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)alertDefId);
            if (!this.checkPermission(subject, alertDefinition)) continue;
            alertDefinition.setDeleted(true);
            ++modifiedCount;
            boolean bl = isResourceLevel = null != alertDefinition.getResource();
            if (isResourceLevel) {
                this.notifyAlertConditionCacheManager("removeAlertDefinitions", alertDefinition, AlertDefinitionEvent.DELETED);
            }
            if (alertDefinition.getResourceGroup() == null) continue;
            alertDefinition.setResourceGroup(null);
        }
        return modifiedCount;
    }

    @Override
    public int enableAlertDefinitions(Subject subject, Integer[] alertDefinitionIds) {
        int modifiedCount = 0;
        boolean isResourceLevel = false;
        Integer[] arr$ = alertDefinitionIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int alertDefId = arr$[i$];
            AlertDefinition alertDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)alertDefId);
            if (!this.checkPermission(subject, alertDefinition) || alertDefinition.getEnabled()) continue;
            alertDefinition.setEnabled(true);
            ++modifiedCount;
            boolean bl = isResourceLevel = null != alertDefinition.getResource();
            if (!isResourceLevel) continue;
            this.notifyAlertConditionCacheManager("enableAlertDefinitions", alertDefinition, AlertDefinitionEvent.ENABLED);
        }
        return modifiedCount;
    }

    @Override
    public boolean isEnabled(Integer definitionId) {
        Query enabledQuery = this.entityManager.createNamedQuery("AlertDefinition.isEnabled");
        enabledQuery.setParameter("alertDefinitionId", (Object)definitionId);
        List resultIds = enabledQuery.getResultList();
        return resultIds.size() == 1;
    }

    @Override
    public boolean isTemplate(Integer definitionId) {
        Query query = this.entityManager.createNamedQuery("AlertDefinition.isTemplate");
        query.setParameter("alertDefinitionId", (Object)definitionId);
        List resultIds = query.getResultList();
        return resultIds.size() == 1;
    }

    @Override
    public boolean isGroupAlertDefinition(Integer definitionId) {
        Query query = this.entityManager.createNamedQuery("AlertDefinition.isGroupAlertDefinition");
        query.setParameter("alertDefinitionId", (Object)definitionId);
        List resultIds = query.getResultList();
        return resultIds.size() == 1;
    }

    @Override
    public boolean isResourceAlertDefinition(Integer definitionId) {
        Query query = this.entityManager.createNamedQuery("AlertDefinition.isResourceAlertDefinition");
        query.setParameter("alertDefinitionId", (Object)definitionId);
        List resultIds = query.getResultList();
        return resultIds.size() == 1;
    }

    @Override
    public int disableAlertDefinitions(Subject subject, Integer[] alertDefinitionIds) {
        int modifiedCount = 0;
        Integer[] arr$ = alertDefinitionIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            boolean isResourceLevel;
            int alertDefId = arr$[i$];
            AlertDefinition alertDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)alertDefId);
            if (!this.checkPermission(subject, alertDefinition) || !alertDefinition.getEnabled()) continue;
            alertDefinition.setEnabled(false);
            ++modifiedCount;
            boolean bl = isResourceLevel = null != alertDefinition.getResource();
            if (!isResourceLevel) continue;
            this.notifyAlertConditionCacheManager("disableAlertDefinitions", alertDefinition, AlertDefinitionEvent.DISABLED);
        }
        return modifiedCount;
    }

    @Override
    public void copyAlertDefinitions(Subject subject, Integer[] alertDefinitionIds) {
        Integer[] arr$ = alertDefinitionIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int alertDefId = arr$[i$];
            AlertDefinition alertDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)alertDefId);
            if (!this.checkPermission(subject, alertDefinition)) continue;
            AlertDefinition newAlertDefinition = new AlertDefinition(alertDefinition);
            newAlertDefinition.setEnabled(false);
            newAlertDefinition.setParentId(alertDefinition.getParentId());
            newAlertDefinition.setResource(alertDefinition.getResource());
            newAlertDefinition.setResourceType(alertDefinition.getResourceType());
            newAlertDefinition.setResourceGroup(alertDefinition.getResourceGroup());
            newAlertDefinition.setGroupAlertDefinition(alertDefinition.getGroupAlertDefinition());
            this.entityManager.persist((Object)newAlertDefinition);
            this.notifyAlertConditionCacheManager("copyAlertDefinitions", alertDefinition, AlertDefinitionEvent.CREATED);
        }
    }

    @Override
    public List<AlertDefinition> findAllRecoveryDefinitionsById(Subject subject, Integer alertDefinitionId) {
        if (!this.authorizationManager.isOverlord(subject)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to call " + "getAllRecoveryDefinitionsById; only the overlord has that right");
        }
        Query query = this.entityManager.createNamedQuery("AlertDefinition.findAllByRecoveryDefinitionId");
        query.setParameter("recoveryDefinitionId", (Object)alertDefinitionId);
        List list = query.getResultList();
        return list;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public AlertDefinition updateAlertDefinition(Subject subject, int alertDefinitionId, AlertDefinition alertDefinition, boolean purgeInternals) throws InvalidAlertDefinitionException, AlertDefinitionUpdateException {
        AlertDefinition oldAlertDefinition;
        if (purgeInternals) {
            this.alertDefinitionManager.purgeInternals(alertDefinitionId);
        }
        if (!this.checkPermission(subject, oldAlertDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)alertDefinitionId))) {
            if (oldAlertDefinition.getResourceType() != null) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to modify alert templates for type [" + oldAlertDefinition.getResourceType() + "]");
            }
            if (oldAlertDefinition.getResourceGroup() != null) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to modify alert definitions for group [" + oldAlertDefinition.getResourceGroup() + "]");
            }
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to modify alert definitions for resource [" + oldAlertDefinition.getResource() + "]");
        }
        boolean isResourceLevel = oldAlertDefinition.getResource() != null;
        this.checkAlertDefinition(alertDefinition, isResourceLevel ? Integer.valueOf(oldAlertDefinition.getResource().getId()) : null);
        if (oldAlertDefinition.getDeleted()) {
            throw new AlertDefinitionUpdateException("Can not update deleted " + oldAlertDefinition.toSimpleString());
        }
        AlertDefinitionUpdateType updateType = AlertDefinitionUpdateType.get(oldAlertDefinition, alertDefinition);
        if (isResourceLevel && (updateType == AlertDefinitionUpdateType.JUST_DISABLED || updateType == AlertDefinitionUpdateType.STILL_ENABLED)) {
            LOG.debug((Object)("Updating AlertConditionCacheManager with AlertDefinition[ id=" + oldAlertDefinition.getId() + " ]...DELETING"));
            for (AlertCondition nextCondition : oldAlertDefinition.getConditions()) {
                LOG.debug((Object)("OldAlertCondition[ id=" + nextCondition.getId() + " ]"));
            }
            this.notifyAlertConditionCacheManager("updateAlertDefinition", oldAlertDefinition, AlertDefinitionEvent.DELETED);
        }
        if (alertDefinition.getConditions().size() == 1) {
            alertDefinition.setConditionExpression(BooleanExpression.ANY);
        }
        oldAlertDefinition.update(alertDefinition);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating: " + oldAlertDefinition));
            for (AlertCondition nextCondition : oldAlertDefinition.getConditions()) {
                LOG.debug((Object)("Condition: " + nextCondition));
            }
            for (AlertNotification nextNotification : oldAlertDefinition.getAlertNotifications()) {
                LOG.debug((Object)("Notification: " + nextNotification));
                LOG.debug((Object)("Notification-Configuration: " + nextNotification.getConfiguration().toString(true)));
                if (nextNotification.getExtraConfiguration() == null) continue;
                LOG.debug((Object)("Notification-Extra-Configuration: " + nextNotification.getExtraConfiguration().toString(true)));
            }
        }
        this.fixRecoveryId(oldAlertDefinition);
        AlertDefinition newAlertDefinition = (AlertDefinition)this.entityManager.merge((Object)oldAlertDefinition);
        if (isResourceLevel && (updateType == AlertDefinitionUpdateType.JUST_ENABLED || updateType == AlertDefinitionUpdateType.STILL_ENABLED)) {
            boolean addToCache = false;
            if (newAlertDefinition.getRecoveryId() != 0) {
                AlertDefinition toBeRecoveredDefinition = this.getAlertDefinitionById(subject, newAlertDefinition.getRecoveryId());
                if (!toBeRecoveredDefinition.getEnabled()) {
                    addToCache = true;
                }
            } else {
                addToCache = true;
            }
            if (addToCache) {
                LOG.debug((Object)("Updating AlertConditionCacheManager with AlertDefinition[ id=" + newAlertDefinition.getId() + " ]...CREATING"));
                for (AlertCondition nextCondition : newAlertDefinition.getConditions()) {
                    LOG.debug((Object)("NewAlertCondition[ id=" + nextCondition.getId() + " ]"));
                }
                this.notifyAlertConditionCacheManager("updateAlertDefinition", newAlertDefinition, AlertDefinitionEvent.CREATED);
            }
        }
        return newAlertDefinition;
    }

    private void checkAlertDefinition(AlertDefinition alertDefinition, Integer resourceId) throws InvalidAlertDefinitionException {
        for (AlertCondition alertCondition : alertDefinition.getConditions()) {
            MeasurementDefinition def;
            AlertConditionCategory alertConditionCategory = alertCondition.getCategory();
            if (alertConditionCategory == AlertConditionCategory.ALERT) {
                throw new InvalidAlertDefinitionException("AlertDefinitionManager does not yet support condition category: " + alertConditionCategory);
            }
            if (alertConditionCategory != AlertConditionCategory.BASELINE || (def = alertCondition.getMeasurementDefinition()).getNumericType() == NumericType.DYNAMIC) continue;
            throw new InvalidAlertDefinitionException("Invalid Condition: '" + def.getDisplayName() + "' is a trending metric, and thus will never have baselines calculated for it.");
        }
    }

    private void notifyAlertConditionCacheManager(String methodName, AlertDefinition alertDefinition, AlertDefinitionEvent alertDefinitionEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Invoking... " + methodName + " with AlertDefinitionEvent[" + (Object)((Object)alertDefinitionEvent) + "]"));
        }
        if (alertDefinitionEvent == AlertDefinitionEvent.CREATED) {
            if (alertDefinition.getResource() != null) {
                int resourceId = alertDefinition.getResource().getId();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Invoking... agentStatusManager.updateByResource(" + resourceId + ")"));
                }
                this.agentStatusManager.updateByResource(resourceId);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"notifyAlertConditionCacheManager skipping alert template or group alert definition");
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Invoking... agentStatusManager.updateByAlertDefinition(" + alertDefinition.getId() + ")"));
            }
            this.agentStatusManager.updateByAlertDefinition(alertDefinition.getId());
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void purgeInternals(int alertDefinitionId) {
        try {
            Query alertDampeningEventPurgeQuery = this.entityManager.createNamedQuery("AlertDampeningEvent.deleteByAlertDefinitionId");
            Query unmatchedAlertConditionLogPurgeQuery = this.entityManager.createNamedQuery("AlertConditionLog.deleteUnmatchedByAlertDefinitionId");
            alertDampeningEventPurgeQuery.setParameter("alertDefinitionId", (Object)alertDefinitionId);
            unmatchedAlertConditionLogPurgeQuery.setParameter("alertDefinitionId", (Object)alertDefinitionId);
            int alertDampeningEventPurgeCount = alertDampeningEventPurgeQuery.executeUpdate();
            int unmatchedAlertConditionLogPurgeCount = unmatchedAlertConditionLogPurgeQuery.executeUpdate();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Update to AlertDefinition[id=" + alertDefinitionId + " caused a purge of internal, dampening constructs."));
                if (alertDampeningEventPurgeCount > 0) {
                    LOG.debug((Object)("Removed " + alertDampeningEventPurgeCount + " AlertDampeningEvent" + (alertDampeningEventPurgeCount == 1 ? "" : "s")));
                }
                if (unmatchedAlertConditionLogPurgeCount > 0) {
                    LOG.debug((Object)("Removed " + unmatchedAlertConditionLogPurgeCount + " unmatched AlertConditionLog" + (unmatchedAlertConditionLogPurgeCount == 1 ? "" : "s")));
                }
            }
        }
        catch (Throwable t) {
            LOG.debug((Object)("Could not purge internal alerting constructs for: " + alertDefinitionId), t);
        }
    }

    @Override
    public int purgeUnusedAlertDefinition() {
        Query purgeQuery = this.entityManager.createNamedQuery("AlertDefinition.findUnusedDefinitionIds");
        List resultIds = purgeQuery.getResultList();
        int removed = 0;
        Iterator i$ = resultIds.iterator();
        while (i$.hasNext()) {
            int unusedDefinitionId = (Integer)i$.next();
            AlertDefinition unusedDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)unusedDefinitionId);
            if (unusedDefinition != null) {
                this.entityManager.remove((Object)unusedDefinition);
                ++removed;
                continue;
            }
            LOG.warn((Object)("Could not find alertDefinition[id=" + unusedDefinitionId + "] for purge"));
        }
        return removed;
    }

    @Override
    public AlertDefinition getAlertDefinition(Subject subject, int alertDefinitionId) {
        return this.getAlertDefinitionById(subject, alertDefinitionId);
    }

    @Override
    public PageList<AlertDefinition> findAlertDefinitionsByCriteria(Subject subject, AlertDefinitionCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE, subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AlertDefinitionUpdateType {
        JUST_ENABLED,
        JUST_DISABLED,
        STILL_ENABLED,
        STILL_DISABLED;


        public static AlertDefinitionUpdateType get(AlertDefinition oldDefinition, AlertDefinition newDefinition) {
            if (!oldDefinition.getEnabled() && newDefinition.getEnabled()) {
                return JUST_ENABLED;
            }
            if (oldDefinition.getEnabled() && !newDefinition.getEnabled()) {
                return JUST_DISABLED;
            }
            if (oldDefinition.getEnabled() && newDefinition.getEnabled()) {
                return STILL_ENABLED;
            }
            return STILL_DISABLED;
        }
    }
}

