/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodUtil {
    private static final Log log = LogFactory.getLog(MethodUtil.class);

    private MethodUtil() {
    }

    private static boolean isCompatible(Class[] declaredParams, Object[] params) {
        if (params.length != declaredParams.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            if (declaredParams[i].isInstance(params[i])) continue;
            return false;
        }
        return true;
    }

    public static Object getClassFromSystemProperty(String className, Object ... args) {
        if (System.getProperties().containsKey(className)) {
            String overridename = System.getProperty(className);
            return MethodUtil.callNewMethod(overridename, args);
        }
        return MethodUtil.callNewMethod(className, args);
    }

    private static Object callNewMethod(String className, Object ... args) {
        Object retval;
        block9: {
            retval = null;
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                if (args == null || args.length == 0) {
                    retval = clazz.newInstance();
                    break block9;
                }
                try {
                    Constructor<?>[] ctors;
                    for (Constructor<?> ctor : ctors = clazz.getConstructors()) {
                        if (!MethodUtil.isCompatible(ctor.getParameterTypes(), args)) continue;
                        return ctor.newInstance(args);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return retval;
    }
}

