/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;

public final class Spliterators {
    private static final Spliterator<Object> EMPTY_SPLITERATOR;
    private static final Spliterator.OfInt EMPTY_INT_SPLITERATOR;
    private static final Spliterator.OfLong EMPTY_LONG_SPLITERATOR;
    private static final Spliterator.OfDouble EMPTY_DOUBLE_SPLITERATOR;

    public static <T> Spliterator<T> emptySpliterator() {
        return null;
    }

    public static Spliterator.OfInt emptyIntSpliterator() {
        return null;
    }

    public static Spliterator.OfLong emptyLongSpliterator() {
        return null;
    }

    public static Spliterator.OfDouble emptyDoubleSpliterator() {
        return null;
    }

    public static <T> Spliterator<T> spliterator(Object[] objectArray, int n) {
        return null;
    }

    public static <T> Spliterator<T> spliterator(Object[] objectArray, int n, int n2, int n3) {
        return null;
    }

    public static Spliterator.OfInt spliterator(int[] nArray, int n) {
        return null;
    }

    public static Spliterator.OfInt spliterator(int[] nArray, int n, int n2, int n3) {
        return null;
    }

    public static Spliterator.OfLong spliterator(long[] lArray, int n) {
        return null;
    }

    public static Spliterator.OfLong spliterator(long[] lArray, int n, int n2, int n3) {
        return null;
    }

    public static Spliterator.OfDouble spliterator(double[] dArray, int n) {
        return null;
    }

    public static Spliterator.OfDouble spliterator(double[] dArray, int n, int n2, int n3) {
        return null;
    }

    public static <T> Spliterator<T> spliterator(Collection<? extends T> collection, int n) {
        return null;
    }

    public static <T> Spliterator<T> spliterator(Iterator<? extends T> iterator, long l, int n) {
        return null;
    }

    public static <T> Spliterator<T> spliteratorUnknownSize(Iterator<? extends T> iterator, int n) {
        return null;
    }

    public static Spliterator.OfInt spliterator(PrimitiveIterator.OfInt ofInt, long l, int n) {
        return null;
    }

    public static Spliterator.OfInt spliteratorUnknownSize(PrimitiveIterator.OfInt ofInt, int n) {
        return null;
    }

    public static Spliterator.OfLong spliterator(PrimitiveIterator.OfLong ofLong, long l, int n) {
        return null;
    }

    public static Spliterator.OfLong spliteratorUnknownSize(PrimitiveIterator.OfLong ofLong, int n) {
        return null;
    }

    public static Spliterator.OfDouble spliterator(PrimitiveIterator.OfDouble ofDouble, long l, int n) {
        return null;
    }

    public static Spliterator.OfDouble spliteratorUnknownSize(PrimitiveIterator.OfDouble ofDouble, int n) {
        return null;
    }

    public static <T> Iterator<T> iterator(Spliterator<? extends T> spliterator) {
        return null;
    }

    public static PrimitiveIterator.OfInt iterator(Spliterator.OfInt ofInt) {
        return null;
    }

    public static PrimitiveIterator.OfLong iterator(Spliterator.OfLong ofLong) {
        return null;
    }

    public static PrimitiveIterator.OfDouble iterator(Spliterator.OfDouble ofDouble) {
        return null;
    }

    static final class DoubleIteratorSpliterator
    implements Spliterator.OfDouble {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final PrimitiveIterator.OfDouble it;
        private final int characteristics;
        private long est;
        private int batch;

        public DoubleIteratorSpliterator(PrimitiveIterator.OfDouble iterator, long size, int characteristics) {
            this.it = iterator;
            this.est = size;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        public DoubleIteratorSpliterator(PrimitiveIterator.OfDouble iterator, int characteristics) {
            this.it = iterator;
            this.est = Long.MAX_VALUE;
            this.characteristics = characteristics & 0xFFFFBFBF;
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            PrimitiveIterator.OfDouble i = this.it;
            long s = this.est;
            if (s > 1L && i.hasNext()) {
                int n = this.batch + 1024;
                if ((long)n > s) {
                    n = (int)s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                double[] a = new double[n];
                int j = 0;
                do {
                    a[j] = i.nextDouble();
                } while (++j < n && i.hasNext());
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                    return new DoubleArraySpliterator(a, 0, j, this.characteristics);
                }
                return new DoubleArraySpliterator(a, 0, j, this.characteristics, 0x3FFFFFFFFFFFFFFFL);
            }
            return null;
        }

        @Override
        public void forEachRemaining(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            this.it.forEachRemaining(action);
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.it.hasNext()) {
                action.accept(this.it.nextDouble());
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Double> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class LongIteratorSpliterator
    implements Spliterator.OfLong {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final PrimitiveIterator.OfLong it;
        private final int characteristics;
        private long est;
        private int batch;

        public LongIteratorSpliterator(PrimitiveIterator.OfLong iterator, long size, int characteristics) {
            this.it = iterator;
            this.est = size;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        public LongIteratorSpliterator(PrimitiveIterator.OfLong iterator, int characteristics) {
            this.it = iterator;
            this.est = Long.MAX_VALUE;
            this.characteristics = characteristics & 0xFFFFBFBF;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            PrimitiveIterator.OfLong i = this.it;
            long s = this.est;
            if (s > 1L && i.hasNext()) {
                int n = this.batch + 1024;
                if ((long)n > s) {
                    n = (int)s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                long[] a = new long[n];
                int j = 0;
                do {
                    a[j] = i.nextLong();
                } while (++j < n && i.hasNext());
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                    return new LongArraySpliterator(a, 0, j, this.characteristics);
                }
                return new LongArraySpliterator(a, 0, j, this.characteristics, 0x3FFFFFFFFFFFFFFFL);
            }
            return null;
        }

        @Override
        public void forEachRemaining(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            this.it.forEachRemaining(action);
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.it.hasNext()) {
                action.accept(this.it.nextLong());
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class IntIteratorSpliterator
    implements Spliterator.OfInt {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final PrimitiveIterator.OfInt it;
        private final int characteristics;
        private long est;
        private int batch;

        public IntIteratorSpliterator(PrimitiveIterator.OfInt iterator, long size, int characteristics) {
            this.it = iterator;
            this.est = size;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        public IntIteratorSpliterator(PrimitiveIterator.OfInt iterator, int characteristics) {
            this.it = iterator;
            this.est = Long.MAX_VALUE;
            this.characteristics = characteristics & 0xFFFFBFBF;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            PrimitiveIterator.OfInt i = this.it;
            long s = this.est;
            if (s > 1L && i.hasNext()) {
                int n = this.batch + 1024;
                if ((long)n > s) {
                    n = (int)s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                int[] a = new int[n];
                int j = 0;
                do {
                    a[j] = i.nextInt();
                } while (++j < n && i.hasNext());
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                    return new IntArraySpliterator(a, 0, j, this.characteristics);
                }
                return new IntArraySpliterator(a, 0, j, this.characteristics, 0x3FFFFFFFFFFFFFFFL);
            }
            return null;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            this.it.forEachRemaining(action);
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.it.hasNext()) {
                action.accept(this.it.nextInt());
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static class IteratorSpliterator<T>
    implements Spliterator<T> {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final Collection<? extends T> collection;
        private Iterator<? extends T> it;
        private final int characteristics;
        private long est;
        private int batch;

        public IteratorSpliterator(Collection<? extends T> collection, int characteristics) {
            this.collection = collection;
            this.it = null;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        public IteratorSpliterator(Iterator<? extends T> iterator, long size, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = size;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        public IteratorSpliterator(Iterator<? extends T> iterator, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = Long.MAX_VALUE;
            this.characteristics = characteristics & 0xFFFFBFBF;
        }

        @Override
        public Spliterator<T> trySplit() {
            long s;
            Iterator<Object> i = this.it;
            if (i == null) {
                this.it = this.collection.iterator();
                i = this.it;
                s = this.est = (long)this.collection.size();
            } else {
                s = this.est;
            }
            if (s > 1L && i.hasNext()) {
                int n = this.batch + 1024;
                if ((long)n > s) {
                    n = (int)s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                Object[] a = new Object[n];
                int j = 0;
                do {
                    a[j] = i.next();
                } while (++j < n && i.hasNext());
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                    return new ArraySpliterator(a, 0, j, this.characteristics);
                }
                return new ArraySpliterator(a, 0, j, this.characteristics, 0x3FFFFFFFFFFFFFFFL);
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Iterator<T> i = this.it;
            if (i == null) {
                this.it = this.collection.iterator();
                i = this.it;
                this.est = this.collection.size();
            }
            i.forEachRemaining(action);
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.it == null) {
                this.it = this.collection.iterator();
                this.est = this.collection.size();
            }
            if (this.it.hasNext()) {
                action.accept(this.it.next());
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            if (this.it == null) {
                this.it = this.collection.iterator();
                this.est = this.collection.size();
                return this.est;
            }
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super T> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    public static abstract class AbstractDoubleSpliterator
    implements Spliterator.OfDouble {
        static final int MAX_BATCH = 0x2000000;
        static final int BATCH_UNIT = 1024;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractDoubleSpliterator(long l, int n) {
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        @Override
        public int characteristics() {
            return 0;
        }

        static final class HoldingDoubleConsumer
        implements DoubleConsumer {
            double value;

            HoldingDoubleConsumer() {
            }

            @Override
            public void accept(double value) {
                this.value = value;
            }
        }
    }

    public static abstract class AbstractLongSpliterator
    implements Spliterator.OfLong {
        static final int MAX_BATCH = 0x2000000;
        static final int BATCH_UNIT = 1024;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractLongSpliterator(long l, int n) {
        }

        @Override
        public Spliterator.OfLong trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        @Override
        public int characteristics() {
            return 0;
        }

        static final class HoldingLongConsumer
        implements LongConsumer {
            long value;

            HoldingLongConsumer() {
            }

            @Override
            public void accept(long value) {
                this.value = value;
            }
        }
    }

    public static abstract class AbstractIntSpliterator
    implements Spliterator.OfInt {
        static final int MAX_BATCH = 0x2000000;
        static final int BATCH_UNIT = 1024;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractIntSpliterator(long l, int n) {
        }

        @Override
        public Spliterator.OfInt trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        @Override
        public int characteristics() {
            return 0;
        }

        static final class HoldingIntConsumer
        implements IntConsumer {
            int value;

            HoldingIntConsumer() {
            }

            @Override
            public void accept(int value) {
                this.value = value;
            }
        }
    }

    public static abstract class AbstractSpliterator<T>
    implements Spliterator<T> {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractSpliterator(long l, int n) {
        }

        @Override
        public Spliterator<T> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        @Override
        public int characteristics() {
            return 0;
        }

        static final class HoldingConsumer<T>
        implements Consumer<T> {
            Object value;

            HoldingConsumer() {
            }

            @Override
            public void accept(T value) {
                this.value = value;
            }
        }
    }

    static final class DoubleArraySpliterator
    implements Spliterator.OfDouble {
        private final double[] array;
        private int index;
        private final int fence;
        private final int characteristics;
        private long estimatedSize;

        public DoubleArraySpliterator(double[] array, int additionalCharacteristics) {
            this(array, 0, array.length, additionalCharacteristics);
        }

        public DoubleArraySpliterator(double[] array, int origin, int fence, int additionalCharacteristics) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
            this.estimatedSize = -1L;
        }

        private DoubleArraySpliterator(double[] array, int origin, int fence, int characteristics, long estimatedSize) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = characteristics & 0xFFFFBFBF;
            this.estimatedSize = estimatedSize;
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                return null;
            }
            if (this.estimatedSize == -1L) {
                this.index = mid;
                return new DoubleArraySpliterator(this.array, lo, this.index, this.characteristics);
            }
            long prefixEstimatedSize = this.estimatedSize >>> 1;
            this.estimatedSize -= prefixEstimatedSize;
            this.index = mid;
            return new DoubleArraySpliterator(this.array, lo, this.index, this.characteristics, prefixEstimatedSize);
        }

        @Override
        public void forEachRemaining(DoubleConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            double[] a = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a[i]);
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.estimatedSize >= 0L ? this.estimatedSize : (long)(this.fence - this.index);
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Double> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class LongArraySpliterator
    implements Spliterator.OfLong {
        private final long[] array;
        private int index;
        private final int fence;
        private final int characteristics;
        private long estimatedSize;

        public LongArraySpliterator(long[] array, int additionalCharacteristics) {
            this(array, 0, array.length, additionalCharacteristics);
        }

        public LongArraySpliterator(long[] array, int origin, int fence, int additionalCharacteristics) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
            this.estimatedSize = -1L;
        }

        private LongArraySpliterator(long[] array, int origin, int fence, int characteristics, long estimatedSize) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = characteristics & 0xFFFFBFBF;
            this.estimatedSize = estimatedSize;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                return null;
            }
            if (this.estimatedSize == -1L) {
                this.index = mid;
                return new LongArraySpliterator(this.array, lo, this.index, this.characteristics);
            }
            long prefixEstimatedSize = this.estimatedSize >>> 1;
            this.estimatedSize -= prefixEstimatedSize;
            this.index = mid;
            return new LongArraySpliterator(this.array, lo, this.index, this.characteristics, prefixEstimatedSize);
        }

        @Override
        public void forEachRemaining(LongConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] a = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a[i]);
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.estimatedSize >= 0L ? this.estimatedSize : (long)(this.fence - this.index);
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class IntArraySpliterator
    implements Spliterator.OfInt {
        private final int[] array;
        private int index;
        private final int fence;
        private final int characteristics;
        private long estimatedSize;

        public IntArraySpliterator(int[] array, int additionalCharacteristics) {
            this(array, 0, array.length, additionalCharacteristics);
        }

        public IntArraySpliterator(int[] array, int origin, int fence, int additionalCharacteristics) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
            this.estimatedSize = -1L;
        }

        private IntArraySpliterator(int[] array, int origin, int fence, int characteristics, long estimatedSize) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = characteristics & 0xFFFFBFBF;
            this.estimatedSize = estimatedSize;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                return null;
            }
            if (this.estimatedSize == -1L) {
                this.index = mid;
                return new IntArraySpliterator(this.array, lo, this.index, this.characteristics);
            }
            long prefixEstimatedSize = this.estimatedSize >>> 1;
            this.estimatedSize -= prefixEstimatedSize;
            this.index = mid;
            return new IntArraySpliterator(this.array, lo, this.index, this.characteristics, prefixEstimatedSize);
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] a = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a[i]);
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.estimatedSize >= 0L ? this.estimatedSize : (long)(this.fence - this.index);
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class ArraySpliterator<T>
    implements Spliterator<T> {
        private final Object[] array;
        private int index;
        private final int fence;
        private final int characteristics;
        private long estimatedSize;

        public ArraySpliterator(Object[] array, int additionalCharacteristics) {
            this(array, 0, array.length, additionalCharacteristics);
        }

        public ArraySpliterator(Object[] array, int origin, int fence, int additionalCharacteristics) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
            this.estimatedSize = -1L;
        }

        private ArraySpliterator(Object[] array, int origin, int fence, int characteristics, long estimatedSize) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = characteristics & 0xFFFFBFBF;
            this.estimatedSize = estimatedSize;
        }

        @Override
        public Spliterator<T> trySplit() {
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                return null;
            }
            if (this.estimatedSize == -1L) {
                this.index = mid;
                return new ArraySpliterator<T>(this.array, lo, this.index, this.characteristics);
            }
            long prefixEstimatedSize = this.estimatedSize >>> 1;
            this.estimatedSize -= prefixEstimatedSize;
            this.index = mid;
            return new ArraySpliterator<T>(this.array, lo, this.index, this.characteristics, prefixEstimatedSize);
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] a = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a[i]);
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                Object e = this.array[this.index++];
                action.accept(e);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.estimatedSize >= 0L ? this.estimatedSize : (long)(this.fence - this.index);
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super T> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    private static abstract class EmptySpliterator<T, S extends Spliterator<T>, C> {
        EmptySpliterator() {
        }

        public S trySplit() {
            return null;
        }

        public boolean tryAdvance(C consumer) {
            Objects.requireNonNull(consumer);
            return false;
        }

        public void forEachRemaining(C consumer) {
            Objects.requireNonNull(consumer);
        }

        public long estimateSize() {
            return 0L;
        }

        public int characteristics() {
            return 16448;
        }

        private static final class OfDouble
        extends EmptySpliterator<Double, Spliterator.OfDouble, DoubleConsumer>
        implements Spliterator.OfDouble {
            OfDouble() {
            }
        }

        private static final class OfLong
        extends EmptySpliterator<Long, Spliterator.OfLong, LongConsumer>
        implements Spliterator.OfLong {
            OfLong() {
            }
        }

        private static final class OfInt
        extends EmptySpliterator<Integer, Spliterator.OfInt, IntConsumer>
        implements Spliterator.OfInt {
            OfInt() {
            }
        }

        private static final class OfRef<T>
        extends EmptySpliterator<T, Spliterator<T>, Consumer<? super T>>
        implements Spliterator<T> {
            OfRef() {
            }
        }
    }
}

