/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.StringReader;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Filter;
import net.sf.saxon.IdentityTransformer;
import net.sf.saxon.IdentityTransformerHandler;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.PreparedStyleSheet;
import net.sf.saxon.TemplatesHandlerImpl;
import net.sf.saxon.TransformerHandlerImpl;
import net.sf.saxon.event.PIGrabber;
import net.sf.saxon.event.Sender;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trace.TraceListener;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;

public class TransformerFactoryImpl
extends SAXTransformerFactory {
    private Configuration config = new Configuration();

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        Transformer transformer = templates.newTransformer();
        return transformer;
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return new IdentityTransformer(this.config);
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        PreparedStyleSheet preparedStyleSheet = new PreparedStyleSheet(this.config);
        preparedStyleSheet.prepare(source);
        return preparedStyleSheet;
    }

    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) throws TransformerConfigurationException {
        PIGrabber pIGrabber;
        block6: {
            pIGrabber = new PIGrabber();
            pIGrabber.setFactory(this.config);
            pIGrabber.setCriteria(string, string2, string3);
            pIGrabber.setBaseURI(source.getSystemId());
            pIGrabber.setURIResolver(this.config.getURIResolver());
            try {
                new Sender(this.config).send(source, pIGrabber, NamePool.getDefaultNamePool(), false);
            }
            catch (TransformerException transformerException) {
                if (pIGrabber.isTerminated()) break block6;
                throw new TransformerConfigurationException("Failed while looking for xml-stylesheet PI", transformerException);
            }
        }
        try {
            Source[] sourceArray = pIGrabber.getAssociatedStylesheets();
            if (sourceArray == null) {
                throw new TransformerConfigurationException("No matching <?xml-stylesheet?> processing instruction found");
            }
            return this.compositeStylesheet(source.getSystemId(), sourceArray);
        }
        catch (TransformerException transformerException) {
            if (transformerException instanceof TransformerConfigurationException) {
                throw (TransformerConfigurationException)transformerException;
            }
            throw new TransformerConfigurationException(transformerException);
        }
    }

    private Source compositeStylesheet(String string, Source[] sourceArray) throws TransformerConfigurationException {
        if (sourceArray.length == 1) {
            return sourceArray[0];
        }
        if (sourceArray.length == 0) {
            throw new TransformerConfigurationException("No stylesheets were supplied");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<xsl:stylesheet version='1.0' ");
        stringBuffer.append(" xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>");
        int n = 0;
        while (n < sourceArray.length) {
            stringBuffer.append("<xsl:import href='" + sourceArray[n].getSystemId() + "'/>");
            ++n;
        }
        stringBuffer.append("</xsl:stylesheet>");
        InputSource inputSource = new InputSource();
        inputSource.setSystemId(string);
        inputSource.setCharacterStream(new StringReader(stringBuffer.toString()));
        return new SAXSource(this.config.getSourceParser(), inputSource);
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.config.setURIResolver(uRIResolver);
    }

    public URIResolver getURIResolver() {
        return this.config.getURIResolver();
    }

    public boolean getFeature(String string) {
        if (string.equals("http://javax.xml.transform.sax.SAXSource/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.sax.SAXResult/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.dom.DOMSource/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.dom.DOMResult/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.stream.StreamSource/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.stream.StreamResult/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter")) {
            return true;
        }
        throw new IllegalArgumentException("Unknown feature " + string);
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if (string.equals("http://saxon.sf.net/feature/treeModel")) {
            if (!(object instanceof Integer)) {
                throw new IllegalArgumentException("Tree model must be an Integer");
            }
            this.config.setTreeModel((Integer)object);
        } else if (string.equals("http://saxon.sf.net/feature/allow-external-functions")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException("allow-external-functions must be a boolean");
            }
            this.config.setAllowExternalFunctions((Boolean)object);
        } else if (string.equals("http://saxon.sf.net/feature/trace-external-functions")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException("trace-external-functions must be a boolean");
            }
            this.config.setTraceExternalFunctions((Boolean)object);
        } else if (string.equals("http://saxon.sf.net/feature/timing")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException("Timing must be a boolean");
            }
            this.config.setTiming((Boolean)object);
        } else if (string.equals("http://saxon.sf.net/feature/validation")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException("Validation must be a boolean");
            }
            this.config.setValidation((Boolean)object);
        } else if (string.equals("http://saxon.sf.net/feature/schema-validation")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException("Schema validation must be a boolean");
            }
            this.config.setSchemaValidation((Boolean)object);
        } else if (string.equals("http://saxon.sf.net/feature/traceListener")) {
            if (!(object instanceof TraceListener)) {
                throw new IllegalArgumentException("Trace listener is of wrong class");
            }
            this.config.setTraceListener((TraceListener)object);
        } else if (string.equals("http://saxon.sf.net/feature/linenumbering")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException("Line Numbering value must be Boolean");
            }
            this.config.setLineNumbering((Boolean)object);
        } else if (string.equals("http://saxon.sf.net/feature/recoveryPolicy")) {
            if (!(object instanceof Integer)) {
                throw new IllegalArgumentException("Recovery Policy value must be Integer");
            }
            this.config.setRecoveryPolicy((Integer)object);
        } else if (string.equals("http://saxon.sf.net/feature/messageEmitterClass")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("Message Emitter class must be a String");
            }
            this.config.setMessageEmitterClass((String)object);
        } else if (string.equals("http://saxon.sf.net/feature/sourceParserClass")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("Source Parser class must be a String");
            }
            this.config.setSourceParserClass((String)object);
        } else if (string.equals("http://saxon.sf.net/feature/styleParserClass")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("Style Parser class must be a String");
            }
            this.config.setStyleParserClass((String)object);
        } else if (string.equals("http://saxon.sf.net/feature/outputURIResolver")) {
            if (!(object instanceof OutputURIResolver)) {
                throw new IllegalArgumentException("Output URI resolver value must be an instance of net.sf.saxon.OutputURIResolver");
            }
            this.config.setOutputURIResolver((OutputURIResolver)object);
        } else if (string.equals("http://saxon.sf.net/feature/namePool")) {
            if (!(object instanceof NamePool)) {
                throw new IllegalArgumentException("NAME_POOL value must be an instance of net.sf.saxon.om.NamePool");
            }
            this.config.setTargetNamePool((NamePool)object);
        } else {
            throw new IllegalArgumentException("Unknown attribute " + string);
        }
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        if (string.equals("http://saxon.sf.net/feature/treeModel")) {
            return new Integer(this.config.getTreeModel());
        }
        if (string.equals("http://saxon.sf.net/feature/timing")) {
            return this.config.isTiming();
        }
        if (string.equals("http://saxon.sf.net/feature/validation")) {
            return this.config.isValidation();
        }
        if (string.equals("http://saxon.sf.net/feature/allow-external-functions")) {
            return this.config.isAllowExternalFunctions();
        }
        if (string.equals("http://saxon.sf.net/feature/trace-external-functions")) {
            return this.config.isTraceExternalFunctions();
        }
        if (string.equals("http://saxon.sf.net/feature/traceListener")) {
            return this.config.getTraceListener();
        }
        if (string.equals("http://saxon.sf.net/feature/linenumbering")) {
            return this.config.isLineNumbering();
        }
        if (string.equals("http://saxon.sf.net/feature/recoveryPolicy")) {
            return new Integer(this.config.getRecoveryPolicy());
        }
        if (string.equals("http://saxon.sf.net/feature/messageEmitterClass")) {
            return this.config.getMessageEmitterClass();
        }
        if (string.equals("http://saxon.sf.net/feature/sourceParserClass")) {
            return this.config.getSourceParserClass();
        }
        if (string.equals("http://saxon.sf.net/feature/styleParserClass")) {
            return this.config.getStyleParserClass();
        }
        if (string.equals("http://saxon.sf.net/feature/outputURIResolver")) {
            return this.config.getOutputURIResolver();
        }
        throw new IllegalArgumentException("Unknown attribute " + string);
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        this.config.setErrorListener(errorListener);
    }

    public ErrorListener getErrorListener() {
        return this.config.getErrorListener();
    }

    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        return this.newTransformerHandler(templates);
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        if (!(templates instanceof PreparedStyleSheet)) {
            throw new TransformerConfigurationException("Templates object was not created by Saxon");
        }
        Controller controller = (Controller)templates.newTransformer();
        TransformerHandlerImpl transformerHandlerImpl = new TransformerHandlerImpl(controller);
        return transformerHandlerImpl;
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        IdentityTransformer identityTransformer = new IdentityTransformer(this.config);
        return new IdentityTransformerHandler(identityTransformer);
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new TemplatesHandlerImpl(this.config);
    }

    public XMLFilter newXMLFilter(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        return this.newXMLFilter(templates);
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        if (!(templates instanceof PreparedStyleSheet)) {
            throw new TransformerConfigurationException("Supplied Templates object was not created using Saxon");
        }
        Controller controller = (Controller)templates.newTransformer();
        return new Filter(controller);
    }
}

