/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.file;

import alt.jiapi.file.Attribute;
import alt.jiapi.file.CodeAttribute;
import alt.jiapi.file.Configuration;
import alt.jiapi.file.ConstantPool;
import alt.jiapi.file.ConstantValueAttribute;
import alt.jiapi.file.DeprecatedAttribute;
import alt.jiapi.file.ExceptionsAttribute;
import alt.jiapi.file.Field;
import alt.jiapi.file.InnerClassesAttribute;
import alt.jiapi.file.Interface;
import alt.jiapi.file.Method;
import alt.jiapi.file.ParseException;
import alt.jiapi.file.SourceFileAttribute;
import alt.jiapi.file.SyntheticAttribute;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public class ClassFile {
    private static Configuration config = new Configuration();
    private ConstantPool constantPool;
    private List interfaces = new LinkedList();
    private List fields = new LinkedList();
    private List methods = new LinkedList();
    private List attributes = new LinkedList();
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    private int magic_number;
    private short minor_version;
    private short major_version;
    private short access_flags;
    private short this_class;
    private short super_class;

    public static void main(String[] args) throws Exception {
        ClassFile cf = ClassFile.parse(args[0]);
        System.out.println(cf.getMagicNumber());
        System.out.println(cf.getMajorVersion() + " " + cf.getMinorVersion());
        System.out.println(cf.getAccessFlags());
        System.out.println(cf.getConstantPool());
    }

    public ClassFile(String className) {
        String name = className.replace('.', '/');
        this.magic_number = -889275714;
        this.minor_version = 0;
        this.major_version = (short)46;
        this.access_flags = 1;
        this.constantPool = new ConstantPool();
        this.this_class = this.constantPool.addClassInfo(name).getEntryIndex();
        this.super_class = this.constantPool.addClassInfo("java.lang.Object").getEntryIndex();
        this.interfaces = new LinkedList();
        this.methods = new LinkedList();
        this.fields = new LinkedList();
        this.attributes = new LinkedList();
    }

    private ClassFile() {
    }

    public static ClassFile parse(String fileName) throws ParseException, IOException {
        return ClassFile.parse(new FileInputStream(fileName));
    }

    public static ClassFile parse(InputStream is) throws ParseException, IOException {
        InputStream input = null;
        if (config.getBoolean("alt.jiapi.file.use-ZipFileInputStream-bug-workaround")) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(is.available());
            int i = 0;
            while ((i = is.read()) != -1) {
                bos.write(i);
            }
            input = new ByteArrayInputStream(bos.toByteArray());
        } else {
            input = is;
        }
        DataInputStream dis = new DataInputStream(input);
        ClassFile cf = null;
        try {
            cf = new ClassFile();
            cf.parseClassFile(dis);
            if (dis.available() != 0) {
                System.out.println(is.available() + ":::" + dis.available() + ":" + is);
                System.out.println("" + dis.readByte());
            }
        }
        catch (EOFException eof) {
            System.out.println(">>Got EOFException: " + eof + "," + is.available() + ", " + cf.getClassName());
        }
        catch (IOException ioe) {
            System.out.println("Got IOException: " + ioe + "," + is.available() + ", " + cf.getClassName());
            throw new ParseException(ioe.getMessage(), cf);
        }
        finally {
            dis.close();
        }
        return cf;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public void addInterface(String name) {
        String iType = name.replace('.', '/');
        short nameIndex = this.constantPool.addUtf8Info(iType).getEntryIndex();
        short cInfo = this.constantPool.addClassInfo(nameIndex);
        this.interfaces.add(new Interface(this.constantPool, cInfo));
    }

    public int getMagicNumber() {
        return this.magic_number;
    }

    public short getMinorVersion() {
        return this.minor_version;
    }

    public short getMajorVersion() {
        return this.major_version;
    }

    public List getFields() {
        return this.fields;
    }

    public List getInterfaces() {
        return this.interfaces;
    }

    public List getMethods() {
        return this.methods;
    }

    public String getClassName() {
        return this.constantPool.getClassName(this.this_class);
    }

    public String getSuperclassName() {
        if (this.super_class != 0) {
            return this.constantPool.getClassName(this.super_class);
        }
        return null;
    }

    public short getAccessFlags() {
        return this.access_flags;
    }

    public void setAccessFlags(short access_flags) {
        this.access_flags = access_flags;
    }

    public short getSuperClassIndex() {
        return this.super_class;
    }

    public short getThisClassIndex() {
        return this.this_class;
    }

    public byte[] toBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(this.magic_number);
            dos.writeShort(this.minor_version);
            dos.writeShort(this.major_version);
            this.writeConstantPool(dos);
            dos.writeShort(this.access_flags);
            dos.writeShort(this.this_class);
            dos.writeShort(this.super_class);
            this.writeInterfaces(dos);
            this.writeFields(dos);
            this.writeMethods(dos);
            this.writeAttributes(dos, this.attributes);
        }
        catch (IOException ioe) {
            throw new ParseException(ioe.getMessage(), this);
        }
        return baos.toByteArray();
    }

    private void parseClassFile(DataInputStream dis) throws ParseException, IOException {
        this.magic_number = dis.readInt();
        this.minor_version = dis.readShort();
        this.major_version = dis.readShort();
        this.parseConstantPool(dis);
        this.access_flags = dis.readShort();
        this.this_class = dis.readShort();
        this.super_class = dis.readShort();
        this.readInterfaces(dis);
        this.readFields(dis);
        this.readMethods(dis);
        this.attributes = this.readAttributes(dis);
    }

    void addInterface(short constantClassIndex) {
        this.interfaces.add(new Interface(this.constantPool, constantClassIndex));
    }

    void addField(short access_flags, short name_index, short descriptor_index, List attributes) {
        this.fields.add(new Field(this.constantPool, access_flags, name_index, descriptor_index, attributes));
    }

    void addMethod(short access_flags, short name_index, short descriptor_index, List attributes) {
        this.methods.add(new Method(this.constantPool, access_flags, name_index, descriptor_index, attributes));
    }

    private void readInterfaces(DataInputStream dis) throws IOException {
        int iCount = dis.readShort();
        Interface[] interfaces = new Interface[iCount];
        for (int i = 0; i < iCount; ++i) {
            short constantClassIndex = dis.readShort();
            this.addInterface(constantClassIndex);
        }
    }

    private void readFields(DataInputStream dis) throws IOException {
        int fCount = dis.readShort();
        Field[] fields = new Field[fCount];
        for (int i = 0; i < fCount; ++i) {
            short access_flags = dis.readShort();
            short name_index = dis.readShort();
            short descriptor_index = dis.readShort();
            List attributes = this.readAttributes(dis);
            this.addField(access_flags, name_index, descriptor_index, attributes);
        }
    }

    private void readMethods(DataInputStream dis) throws IOException {
        int mCount = dis.readShort();
        Method[] methods = new Method[mCount];
        for (int i = 0; i < mCount; ++i) {
            short access_flags = dis.readShort();
            short name_index = dis.readShort();
            short descriptor_index = dis.readShort();
            List attributes = this.readAttributes(dis);
            this.addMethod(access_flags, name_index, descriptor_index, attributes);
        }
    }

    List readAttributes(DataInputStream dis) throws IOException {
        int attr_count = dis.readShort();
        LinkedList<CodeAttribute> attrs = new LinkedList<CodeAttribute>();
        for (int i = 0; i < attr_count; ++i) {
            short attribute_name_index = dis.readShort();
            int attribute_length = dis.readInt();
            String attrName = this.getUtf8(attribute_name_index);
            Attribute a = null;
            a = "Code".equals(attrName) ? new CodeAttribute(this.constantPool, attribute_name_index, dis) : ("Exceptions".equals(attrName) ? new ExceptionsAttribute(attribute_name_index, dis) : ("ConstantValue".equals(attrName) ? new ConstantValueAttribute(attribute_name_index, dis) : ("InnerClasses".equals(attrName) ? new InnerClassesAttribute(attribute_name_index, dis) : ("Synthetic".equals(attrName) ? new SyntheticAttribute(attribute_name_index, dis) : ("SourceFile".equals(attrName) ? new SourceFileAttribute(attribute_name_index, dis) : ("Deprecated".equals(attrName) ? new DeprecatedAttribute(attribute_name_index, dis) : new Attribute(attribute_name_index, attribute_length, dis)))))));
            a.setConstantPool(this.constantPool);
            attrs.add((CodeAttribute)a);
        }
        return attrs;
    }

    private void parseConstantPool(DataInputStream dis) throws IOException {
        short constantPoolCount = dis.readShort();
        this.constantPool = new ConstantPool(constantPoolCount - 1);
        block13: for (int i = 0; i < constantPoolCount - 1; ++i) {
            byte tag = dis.readByte();
            switch (tag) {
                case 7: {
                    this.constantPool.addClassInfo(dis.readShort());
                    continue block13;
                }
                case 9: {
                    this.constantPool.addFieldRefInfo(dis.readShort(), dis.readShort());
                    continue block13;
                }
                case 10: {
                    this.constantPool.addMethodRefInfo(dis.readShort(), dis.readShort());
                    continue block13;
                }
                case 11: {
                    this.constantPool.addInterfaceMethodRefInfo(dis.readShort(), dis.readShort());
                    continue block13;
                }
                case 8: {
                    this.constantPool.addString_info(dis.readShort());
                    continue block13;
                }
                case 3: {
                    this.constantPool.addInteger_info(dis.readInt());
                    continue block13;
                }
                case 4: {
                    this.constantPool.addFloat_info(dis.readInt());
                    continue block13;
                }
                case 5: {
                    this.constantPool.addLong_info(dis.readInt(), dis.readInt());
                    ++i;
                    continue block13;
                }
                case 6: {
                    this.constantPool.addDouble_info(dis.readInt(), dis.readInt());
                    ++i;
                    continue block13;
                }
                case 12: {
                    this.constantPool.addNameAndTypeInfo(dis.readShort(), dis.readShort());
                    continue block13;
                }
                case 1: {
                    short length = dis.readShort();
                    byte[] byteArray = new byte[length];
                    for (int j = 0; j < byteArray.length; ++j) {
                        byteArray[j] = dis.readByte();
                        if (byteArray[j] != 0 && byteArray[j] < 240) continue;
                        System.out.println("  " + Integer.toHexString(byteArray[j]));
                    }
                    this.constantPool.addUtf8_info(byteArray);
                    continue block13;
                }
                default: {
                    throw new ParseException(this.constantPool + "\nInvalid constant pool tag: " + tag, this);
                }
            }
        }
    }

    private void writeConstantPool(DataOutputStream dos) throws IOException {
        List cp = this.constantPool.getList();
        dos.writeShort(cp.size() + 1);
        for (ConstantPool.Entry e : cp) {
            if (e instanceof ConstantPool.NullEntry) continue;
            if (e.getTag() == 0) {
                System.out.println("ERROR: invalid constant pool tag: 0");
            }
            dos.writeByte(e.getTag());
            e.writeData(dos);
        }
    }

    private void writeInterfaces(DataOutputStream dos) throws IOException {
        dos.writeShort(this.interfaces.size());
        for (Interface iFace : this.interfaces) {
            dos.writeShort(iFace.getConstantClassIndex());
        }
    }

    private void writeFields(DataOutputStream dos) throws IOException {
        dos.writeShort(this.fields.size());
        for (Field f : this.fields) {
            dos.writeShort(f.getAccessFlags());
            dos.writeShort(f.getNameIndex());
            dos.writeShort(f.getDescriptorIndex());
            this.writeAttributes(dos, f.getAttributes());
        }
    }

    private void writeMethods(DataOutputStream dos) throws IOException {
        dos.writeShort(this.methods.size());
        for (Method m : this.methods) {
            dos.writeShort(m.getAccessFlags());
            dos.writeShort(m.getNameIndex());
            dos.writeShort(m.getDescriptorIndex());
            this.writeAttributes(dos, m.getAttributes());
        }
    }

    private void writeAttributes(DataOutputStream dos, List attrs) throws IOException {
        dos.writeShort(attrs.size());
        for (Attribute a : attrs) {
            dos.writeShort(a.getAttributeNameIndex());
            byte[] info = a.getBytes();
            dos.writeInt(info.length);
            for (int j = 0; j < info.length; ++j) {
                dos.writeByte(info[j]);
            }
        }
    }

    private String getUtf8(short index) {
        ConstantPool.Utf8Info utf8 = (ConstantPool.Utf8Info)this.constantPool.get(index);
        String s = new String(utf8.getBytes());
        return s;
    }
}

