/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.IOException;
import java.io.Serializable;

public class BugDesignation
implements XMLWriteable,
Serializable {
    public static final String UNCLASSIFIED = "UNCLASSIFIED";
    @NonNull
    private String designation = "UNCLASSIFIED";
    @javax.annotation.CheckForNull
    private String user;
    private long timestamp;
    private String annotationText;

    @NonNull
    public String getDesignationKey() {
        return this.designation;
    }

    public void setDesignationKey(String designationKey) {
        this.designation = designationKey != null ? designationKey : UNCLASSIFIED;
    }

    @CheckForNull
    public String getUser() {
        return this.user;
    }

    public void setUser(String u) {
        this.user = u;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long ts) {
        this.timestamp = ts;
    }

    @CheckForNull
    public String getAnnotationText() {
        return this.annotationText;
    }

    public void setAnnotationText(String s) {
        this.annotationText = s;
    }

    public void writeXML(XMLOutput xmlOutput) throws IOException {
        XMLAttributeList attributeList = new XMLAttributeList();
        if (this.designation != null && !UNCLASSIFIED.equals(this.designation)) {
            attributeList.addAttribute("designation", this.designation);
        }
        if (this.user != null && !"".equals(this.user)) {
            attributeList.addAttribute("user", this.user);
        }
        if (this.timestamp > 0L) {
            attributeList.addAttribute("timestamp", String.valueOf(this.timestamp));
        }
        if (this.annotationText != null && !"".equals(this.annotationText)) {
            xmlOutput.openTag("UserAnnotation", attributeList);
            xmlOutput.writeCDATA(this.annotationText);
            xmlOutput.closeTag("UserAnnotation");
        } else {
            xmlOutput.openCloseTag("UserAnnotation", attributeList);
        }
    }

    public void merge(@CheckForNull BugDesignation other) {
        if (other == null) {
            return;
        }
        boolean changed = false;
        if ((this.annotationText == null || this.annotationText.length() == 0) && other.annotationText != null && other.annotationText.length() > 0) {
            this.annotationText = other.annotationText;
            changed = true;
        }
        if ((this.designation == null || UNCLASSIFIED.equals(this.designation) || this.designation.length() == 0) && other.designation != null && other.designation.length() > 0) {
            this.designation = other.designation;
            changed = true;
        }
        if (!changed) {
            return;
        }
        if ((this.user == null || this.user.length() == 0) && other.user != null && other.user.length() > 0) {
            this.user = other.user;
        }
        if (this.timestamp == 0L && other.timestamp != 0L) {
            this.timestamp = other.timestamp;
        }
    }
}

