/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationWithSourceLines;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FindBugsDisplayFeatures;
import edu.umd.cs.findbugs.FindBugsMessageFormat;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;

public abstract class PackageMemberAnnotation
extends BugAnnotationWithSourceLines {
    private static final long serialVersionUID = -8208567669352996892L;
    @DottedClassName
    protected final String className;
    protected String description;

    protected PackageMemberAnnotation(@DottedClassName String className, String description) {
        if (className.length() == 0) {
            throw new IllegalArgumentException("Empty classname not allowed");
        }
        if (className.indexOf(47) >= 0) {
            assert (false) : "classname " + className + " should be dotted";
            className = className.replace('/', '.');
        }
        this.className = DescriptorFactory.canonicalizeString(className);
        AnalysisContext context = AnalysisContext.currentAnalysisContext();
        this.sourceFileName = context != null ? context.lookupSourceFile(className) : "<Unknown>";
        this.description = description;
    }

    @DottedClassName
    public final String getClassName() {
        return this.className;
    }

    public final String getPackageName() {
        int lastDot = this.className.lastIndexOf(46);
        if (lastDot < 0) {
            return "";
        }
        return this.className.substring(0, lastDot);
    }

    public final String format(String key, ClassAnnotation primaryClass) {
        if (key.equals("class.givenClass")) {
            return PackageMemberAnnotation.shorten(primaryClass.getPackageName(), this.className);
        }
        if (key.equals("class")) {
            return this.className;
        }
        if (key.equals("package")) {
            return this.getPackageName();
        }
        if (key.equals("") && FindBugsDisplayFeatures.isAbridgedMessages() && primaryClass != null) {
            return this.formatPackageMember("givenClass", primaryClass);
        }
        return this.formatPackageMember(key, primaryClass);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    protected static String shorten(String pkgName, String typeName) {
        String otherPkg;
        int index = typeName.lastIndexOf(46);
        if (index >= 0 && ((otherPkg = typeName.substring(0, index)).equals(pkgName) || otherPkg.equals("java.lang"))) {
            typeName = typeName.substring(index + 1);
        }
        return typeName;
    }

    protected static String removePackage(String typeName) {
        int index = typeName.lastIndexOf(46);
        if (index >= 0) {
            return typeName.substring(index + 1);
        }
        return typeName;
    }

    protected static String removePackageName(String typeName) {
        int index = typeName.lastIndexOf(46);
        if (index >= 0) {
            typeName = typeName.substring(index + 1);
        }
        return typeName;
    }

    protected abstract String formatPackageMember(String var1, ClassAnnotation var2);

    public String toString() {
        String pattern = I18N.instance().getAnnotationDescription(this.description);
        FindBugsMessageFormat format = new FindBugsMessageFormat(pattern);
        return format.format(new BugAnnotation[]{this}, null);
    }

    public boolean isSignificant() {
        return true;
    }
}

