/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.ICodeBaseIterator;
import edu.umd.cs.findbugs.classfile.ICodeBaseLocator;
import edu.umd.cs.findbugs.classfile.impl.AbstractScannableCodeBase;
import edu.umd.cs.findbugs.classfile.impl.ZipFileCodeBaseEntry;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipFileCodeBase
extends AbstractScannableCodeBase {
    ZipFile zipFile;

    public ZipFileCodeBase(ICodeBaseLocator codeBaseLocator, File file) throws IOException {
        super(codeBaseLocator);
        try {
            this.zipFile = new ZipFile(file);
            this.setLastModifiedTime(file.lastModified());
        }
        catch (ZipException e) {
            throw new ZipException("Error opening " + file);
        }
    }

    public ICodeBaseEntry lookupResource(String resourceName) {
        resourceName = this.translateResourceName(resourceName);
        try {
            ZipEntry entry = this.zipFile.getEntry(resourceName);
            if (entry == null) {
                return null;
            }
            return new ZipFileCodeBaseEntry(this, entry);
        }
        catch (IllegalStateException ise) {
            return null;
        }
    }

    public ICodeBaseIterator iterator() {
        final Enumeration<? extends ZipEntry> zipEntryEnumerator = this.zipFile.entries();
        return new ICodeBaseIterator(){
            ZipFileCodeBaseEntry nextEntry;

            public boolean hasNext() {
                this.scanForNextEntry();
                return this.nextEntry != null;
            }

            public ICodeBaseEntry next() throws InterruptedException {
                this.scanForNextEntry();
                if (this.nextEntry == null) {
                    throw new NoSuchElementException();
                }
                ZipFileCodeBaseEntry result = this.nextEntry;
                this.nextEntry = null;
                return result;
            }

            private void scanForNextEntry() {
                while (this.nextEntry == null) {
                    if (!zipEntryEnumerator.hasMoreElements()) {
                        return;
                    }
                    ZipEntry zipEntry = (ZipEntry)zipEntryEnumerator.nextElement();
                    if (zipEntry.isDirectory()) continue;
                    ZipFileCodeBase.this.setLastModifiedTime(zipEntry.getTime());
                    this.nextEntry = new ZipFileCodeBaseEntry(ZipFileCodeBase.this, zipEntry);
                    break;
                }
            }
        };
    }

    public String getPathName() {
        return this.zipFile.getName();
    }

    public void close() {
        try {
            this.zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.zipFile.getName();
    }
}

