/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.config.CommandLine;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.annotation.WillClose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RejarClassesForAnalysis {
    final RejarClassesForAnalysisCommandLine commandLine;
    final int argCount;
    final String[] args;
    int analysisCount = 1;
    int auxilaryCount = 1;
    Set<String> copied = new HashSet<String>();
    int filesToAnalyze = 0;
    int analysisClassCount = 0;
    int auxilaryClassCount = 0;
    ZipOutputStream analyzeOut;
    ZipOutputStream auxilaryOut;
    final byte[] buffer = new byte[8192];

    public RejarClassesForAnalysis(RejarClassesForAnalysisCommandLine commandLine, int argCount, String[] args) {
        this.commandLine = commandLine;
        this.argCount = argCount;
        this.args = args;
    }

    public static List<String> readFromStandardInput() throws IOException {
        return RejarClassesForAnalysis.readFrom(new InputStreamReader(System.in));
    }

    public static List<String> readFrom(@WillClose Reader r) throws IOException {
        BufferedReader in = new BufferedReader(r);
        LinkedList<String> lst = new LinkedList<String>();
        while (true) {
            String s;
            if ((s = in.readLine()) == null) {
                in.close();
                return lst;
            }
            lst.add(s);
        }
    }

    String getNextAuxilaryFileOutput() {
        String result = this.auxilaryCount == 1 ? "auxilary.jar" : "auxilary" + this.auxilaryCount + ".jar";
        ++this.auxilaryCount;
        System.out.println("Starting " + result);
        return result;
    }

    String getNextAnalyzeFileOutput() {
        String result = this.analysisCount == 1 ? "analyze.jar" : "analyze" + this.analysisCount + ".jar";
        ++this.analysisCount;
        System.out.println("Starting " + result);
        return result;
    }

    public static void main(String[] args) throws Exception {
        RejarClassesForAnalysisCommandLine commandLine = new RejarClassesForAnalysisCommandLine();
        int argCount = commandLine.parse(args, 0, Integer.MAX_VALUE, "Usage: " + RejarClassesForAnalysis.class.getName() + " [options] [<jarFile>+] ");
        RejarClassesForAnalysis doit = new RejarClassesForAnalysis(commandLine, argCount, args);
        doit.execute();
    }

    public void execute() throws IOException {
        int oldSize;
        String nextAnalyzeFileOutput = this.getNextAnalyzeFileOutput();
        this.analyzeOut = this.createZipFile(nextAnalyzeFileOutput);
        List<String> fileList = this.commandLine.inputFileList != null ? RejarClassesForAnalysis.readFrom(new FileReader(this.commandLine.inputFileList)) : (this.argCount == this.args.length ? RejarClassesForAnalysis.readFromStandardInput() : Arrays.asList(this.args).subList(this.argCount, this.args.length));
        List<Object> auxFileList = Collections.emptyList();
        if (this.commandLine.auxFileList != null) {
            auxFileList = RejarClassesForAnalysis.readFrom(new FileReader(this.commandLine.auxFileList));
        }
        ArrayList<File> inputZipFiles = new ArrayList<File>(fileList.size());
        ArrayList<File> auxZipFiles = new ArrayList<File>(auxFileList.size());
        for (String string : fileList) {
            File f2 = new File(string);
            if (f2.lastModified() < this.commandLine.maxAge) {
                System.err.println("Skipping " + string + ", too old (" + new Date(f2.lastModified()) + ")");
                continue;
            }
            oldSize = this.copied.size();
            if (!this.processZipEntries(f2, new ZipElementHandler(){

                public void handle(ZipFile file, ZipEntry ze) {
                    String name = ze.getName();
                    String dottedName = name.replace('/', '.');
                    if (RejarClassesForAnalysis.this.commandLine.exclude.matches(dottedName)) {
                        return;
                    }
                    if (RejarClassesForAnalysis.this.copied.add(name) && RejarClassesForAnalysis.this.commandLine.prefix.matches(dottedName)) {
                        ++RejarClassesForAnalysis.this.filesToAnalyze;
                    }
                }
            }) || oldSize >= this.copied.size()) continue;
            inputZipFiles.add(f2);
        }
        for (String string : auxFileList) {
            File f = new File(string);
            if (f.lastModified() < this.commandLine.maxAge) {
                System.err.println("Skipping " + string + ", too old (" + new Date(f.lastModified()) + ")");
                continue;
            }
            oldSize = this.copied.size();
            if (!this.processZipEntries(f, new ZipElementHandler(){

                public void handle(ZipFile file, ZipEntry ze) {
                    RejarClassesForAnalysis.this.copied.add(ze.getName());
                }
            }) || oldSize >= this.copied.size()) continue;
            auxZipFiles.add(f);
        }
        System.out.println("# Zip/jar files: " + inputZipFiles.size());
        System.out.println("# aux Zip/jar files: " + auxZipFiles.size());
        if (this.filesToAnalyze == this.copied.size()) {
            System.out.println("Unique class files: " + this.filesToAnalyze);
        } else {
            System.out.println("Unique class files: " + this.copied.size());
            System.out.println("  files to analyze: " + this.filesToAnalyze);
        }
        if (!this.commandLine.prefix.matchesEverything() || this.filesToAnalyze > this.commandLine.maxClasses) {
            this.auxilaryOut = this.createZipFile(this.getNextAuxilaryFileOutput());
        }
        this.copied.clear();
        final HashSet mentioned = new HashSet();
        for (File f : inputZipFiles) {
            System.err.println("Opening " + f);
            this.processZipEntries(f, new ZipElementHandler(){

                public void handle(ZipFile zipInputFile, ZipEntry ze) throws IOException {
                    String name = ze.getName();
                    String dottedName = name.replace('/', '.');
                    if (RejarClassesForAnalysis.this.commandLine.exclude.matches(dottedName)) {
                        return;
                    }
                    if (!RejarClassesForAnalysis.this.copied.add(name)) {
                        if (mentioned.add(name)) {
                            System.err.println("Skipping duplicate of " + name);
                        }
                        return;
                    }
                    boolean writeToAnalyzeOut = false;
                    boolean writeToAuxilaryOut = false;
                    if (RejarClassesForAnalysis.this.commandLine.prefix.matches(dottedName)) {
                        writeToAnalyzeOut = true;
                        if (RejarClassesForAnalysis.this.filesToAnalyze > RejarClassesForAnalysis.this.commandLine.maxClasses) {
                            writeToAuxilaryOut = true;
                        }
                        ++RejarClassesForAnalysis.this.analysisClassCount;
                        if (RejarClassesForAnalysis.this.analysisClassCount > RejarClassesForAnalysis.this.commandLine.maxClasses) {
                            RejarClassesForAnalysis.this.advanceAnalyzeOut();
                        }
                    } else {
                        boolean bl = writeToAuxilaryOut = RejarClassesForAnalysis.this.auxilaryOut != null;
                    }
                    if (writeToAnalyzeOut) {
                        RejarClassesForAnalysis.this.analyzeOut.putNextEntry(new ZipEntry(name));
                    }
                    if (writeToAuxilaryOut) {
                        ++RejarClassesForAnalysis.this.auxilaryClassCount;
                        if (RejarClassesForAnalysis.this.auxilaryClassCount > 29999) {
                            RejarClassesForAnalysis.this.auxilaryClassCount = 0;
                            RejarClassesForAnalysis.this.advanceAuxilaryOut();
                        }
                        RejarClassesForAnalysis.this.auxilaryOut.putNextEntry(new ZipEntry(name));
                    }
                    RejarClassesForAnalysis.this.copyEntry(zipInputFile, ze, writeToAnalyzeOut, writeToAuxilaryOut);
                }
            });
        }
        for (File f : auxZipFiles) {
            System.err.println("Opening aux file " + f);
            this.processZipEntries(f, new ZipElementHandler(){

                public void handle(ZipFile zipInputFile, ZipEntry ze) throws IOException {
                    String name = ze.getName();
                    if (!RejarClassesForAnalysis.this.copied.add(name)) {
                        System.err.println("Skipping duplicate of " + name);
                        return;
                    }
                    ++RejarClassesForAnalysis.this.auxilaryClassCount;
                    if (RejarClassesForAnalysis.this.auxilaryClassCount > 29999) {
                        RejarClassesForAnalysis.this.auxilaryClassCount = 0;
                        RejarClassesForAnalysis.this.advanceAuxilaryOut();
                    }
                    RejarClassesForAnalysis.this.auxilaryOut.putNextEntry(new ZipEntry(name));
                    RejarClassesForAnalysis.this.copyEntry(zipInputFile, ze, false, true);
                }
            });
        }
        this.analyzeOut.close();
        if (this.auxilaryOut != null) {
            this.auxilaryOut.close();
        }
    }

    private ZipOutputStream createZipFile(String fileName) throws FileNotFoundException {
        File newFile = new File(this.commandLine.outputDir, fileName);
        return new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(newFile)));
    }

    private void copyEntry(ZipFile zipInputFile, ZipEntry ze, boolean writeToAnalyzeOut, boolean writeToAuxilaryOut) throws IOException {
        int bytesRead;
        InputStream zipIn = zipInputFile.getInputStream(ze);
        while ((bytesRead = zipIn.read(this.buffer)) >= 0) {
            if (writeToAnalyzeOut) {
                this.analyzeOut.write(this.buffer, 0, bytesRead);
            }
            if (!writeToAuxilaryOut) continue;
            this.auxilaryOut.write(this.buffer, 0, bytesRead);
        }
        if (writeToAnalyzeOut) {
            this.analyzeOut.closeEntry();
        }
        if (writeToAuxilaryOut) {
            this.auxilaryOut.closeEntry();
        }
        zipIn.close();
    }

    private void advanceAuxilaryOut() throws IOException, FileNotFoundException {
        this.auxilaryOut.close();
        this.auxilaryOut = this.createZipFile(this.getNextAuxilaryFileOutput());
    }

    private void advanceAnalyzeOut() throws IOException, FileNotFoundException {
        this.analysisClassCount = 0;
        this.analyzeOut.close();
        this.analyzeOut = this.createZipFile(this.getNextAnalyzeFileOutput());
    }

    boolean processZipEntries(File f, ZipElementHandler handler) {
        if (!f.exists()) {
            System.out.println("file not found: '" + f + "'");
            return false;
        }
        if (!f.canRead() || f.isDirectory()) {
            System.out.println("not readable: '" + f + "'");
            return false;
        }
        try {
            ZipFile zipInputFile = new ZipFile(f);
            Enumeration<? extends ZipEntry> e = zipInputFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (ze.isDirectory() || !ze.getName().endsWith(".class")) continue;
                handler.handle(zipInputFile, ze);
            }
            zipInputFile.close();
        }
        catch (IOException e) {
            System.out.println("Error processing '" + f + "'");
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    static interface ZipElementHandler {
        public void handle(ZipFile var1, ZipEntry var2) throws IOException;
    }

    static class RejarClassesForAnalysisCommandLine
    extends CommandLine {
        public PrefixMatcher prefix = new PrefixMatcher("");
        public PrefixMatcher exclude = new PrefixMatcher();
        int maxClasses = 29999;
        long maxAge = Long.MIN_VALUE;
        public String inputFileList;
        public String auxFileList;
        File outputDir = new File(".");

        RejarClassesForAnalysisCommandLine() {
            this.addOption("-maxAge", "days", "maximum age in days (ignore jar files older than this)");
            this.addOption("-inputFileList", "filename", "text file containing names of jar files");
            this.addOption("-auxFileList", "filename", "text file containing names of jar files for aux class path");
            this.addOption("-maxClasses", "num", "maximum number of classes per analysis*.jar file");
            this.addOption("-outputDir", "dir", "directory for the generated jar files");
            this.addOption("-prefix", "class name prefix", "prefix of class names that should be analyzed (e.g., edu.umd.cs.)");
            this.addOption("-exclude", "class name prefix", "prefix of class names that should be excluded from both analyze and auxilary jar files (e.g., java)");
        }

        protected void handleOption(String option, String optionExtraPart) throws IOException {
            throw new IllegalArgumentException("Unknown option : " + option);
        }

        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if (option.equals("-prefix")) {
                this.prefix = new PrefixMatcher(argument);
            } else if (option.equals("-exclude")) {
                this.exclude = new PrefixMatcher(argument);
            } else if (option.equals("-inputFileList")) {
                this.inputFileList = argument;
            } else if (option.equals("-auxFileList")) {
                this.auxFileList = argument;
            } else if (option.equals("-maxClasses")) {
                this.maxClasses = Integer.parseInt(argument);
            } else if (option.equals("-maxAge")) {
                this.maxAge = System.currentTimeMillis() - 86400000L * (long)Integer.parseInt(argument);
            } else if (option.equals("-outputDir")) {
                this.outputDir = new File(argument);
            } else {
                throw new IllegalArgumentException("Unknown option : " + option);
            }
        }

        static class PrefixMatcher {
            final String[] prefixes;

            PrefixMatcher(String arg) {
                this.prefixes = arg.split(",");
            }

            PrefixMatcher() {
                this.prefixes = new String[0];
            }

            public boolean matches(String arg) {
                for (String p : this.prefixes) {
                    if (!arg.startsWith(p)) continue;
                    return true;
                }
                return false;
            }

            public boolean matchesEverything() {
                for (String p : this.prefixes) {
                    if (p.length() != 0) continue;
                    return true;
                }
                return false;
            }
        }
    }
}

