/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.workflow.RecursiveSearchForJavaFiles;
import edu.umd.cs.findbugs.workflow.SourceSearcher;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.dom4j.DocumentException;

public class SetBugDatabaseInfo {
    private static final String USAGE = "Usage: <cmd>  [options] [<oldData> [<newData>]]";
    static SourceSearcher sourceSearcher;

    public static void main(String[] args) throws IOException, DocumentException {
        DetectorFactoryCollection.instance();
        SetInfoCommandLine commandLine = new SetInfoCommandLine();
        int argCount = commandLine.parse(args, 0, 2, USAGE);
        Project project = new Project();
        SortedBugCollection origCollection = new SortedBugCollection();
        if (argCount < args.length) {
            origCollection.readXML(args[argCount++], project);
        } else {
            origCollection.readXML(System.in, project);
        }
        if (commandLine.revisionName != null) {
            origCollection.setReleaseName(commandLine.revisionName);
        }
        if (commandLine.revisionTimestamp != 0L) {
            origCollection.setTimestamp(commandLine.revisionTimestamp);
        }
        origCollection.setWithMessages(commandLine.withMessages);
        if (commandLine.exclusionFilterFile != null) {
            project.setSuppressionFilter(Filter.parseFilter(commandLine.exclusionFilterFile));
        }
        for (String source : commandLine.sourcePaths) {
            project.addSourceDir(source);
        }
        HashMap missingFiles = new HashMap();
        if (!commandLine.searchSourcePaths.isEmpty()) {
            sourceSearcher = new SourceSearcher(project);
            for (BugInstance bug : origCollection.getCollection()) {
                SourceLineAnnotation src = bug.getPrimarySourceLineAnnotation();
                if (SetBugDatabaseInfo.sourceSearcher.sourceNotFound.contains(src.getClassName()) || sourceSearcher.findSource(src)) continue;
                HashSet<String> paths = (HashSet<String>)missingFiles.get(src.getSourceFile());
                if (paths == null) {
                    paths = new HashSet<String>();
                    missingFiles.put(src.getSourceFile(), paths);
                }
                String fullPath = SetBugDatabaseInfo.fullPath(src);
                paths.add(fullPath);
            }
            HashSet<String> foundPaths = new HashSet<String>();
            for (String f : commandLine.searchSourcePaths) {
                for (File javaFile : RecursiveSearchForJavaFiles.search(new File(f))) {
                    Set matchingMissingClasses = (Set)missingFiles.get(javaFile.getName());
                    if (matchingMissingClasses == null) continue;
                    for (String sourcePath : matchingMissingClasses) {
                        String path = javaFile.getAbsolutePath();
                        if (!path.endsWith(sourcePath)) continue;
                        String dir = path.substring(0, path.length() - sourcePath.length());
                        foundPaths.add(dir);
                    }
                }
            }
            HashSet<String> toRemove = new HashSet<String>();
            block5: for (String p1 : foundPaths) {
                for (String p2 : foundPaths) {
                    if (p1.equals(p2) || !p1.startsWith(p2)) continue;
                    toRemove.add(p1);
                    continue block5;
                }
            }
            foundPaths.removeAll(toRemove);
            for (String dir : foundPaths) {
                project.addSourceDir(dir);
                if (argCount >= args.length) continue;
                System.out.println("Found " + dir);
            }
        }
        if (argCount < args.length) {
            origCollection.writeXML(args[argCount++], project);
        } else {
            origCollection.writeXML(System.out, project);
        }
    }

    static String fullPath(SourceLineAnnotation src) {
        return src.getPackageName().replace('.', File.separatorChar) + File.separatorChar + src.getSourceFile();
    }

    static class SetInfoCommandLine
    extends CommandLine {
        String revisionName;
        String exclusionFilterFile;
        boolean withMessages = false;
        long revisionTimestamp = 0L;
        public List<String> sourcePaths = new LinkedList<String>();
        public List<String> searchSourcePaths = new LinkedList<String>();

        SetInfoCommandLine() {
            this.addOption("-name", "name", "set name for (last) revision");
            this.addOption("-timestamp", "when", "set timestamp for (last) revision");
            this.addSwitch("-resetSource", "remove all source search paths");
            this.addOption("-source", "directory", "Add this directory to the source search path");
            this.addOption("-findSource", "directory", "Find and add all relevant source directions contained within this directory");
            this.addOption("-suppress", "filter file", "Suppress warnings matched by this file (replaces previous suppressions)");
            this.addSwitch("-withMessages", "Add bug descriptions");
        }

        protected void handleOption(String option, String optionExtraPart) throws IOException {
            if (option.equals("-withMessages")) {
                this.withMessages = true;
            } else if (option.equals("-resetSource")) {
                this.sourcePaths.clear();
            } else {
                throw new IllegalArgumentException("no option " + option);
            }
        }

        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if (option.equals("-name")) {
                this.revisionName = argument;
            } else if (option.equals("-suppress")) {
                this.exclusionFilterFile = argument;
            } else if (option.equals("-timestamp")) {
                this.revisionTimestamp = Date.parse(argument);
            } else if (option.equals("-source")) {
                this.sourcePaths.add(argument);
            } else if (option.equals("-findSource")) {
                this.searchSourcePaths.add(argument);
            } else {
                throw new IllegalArgumentException("Can't handle option " + option);
            }
        }
    }
}

