/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.invm;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.remoting.impl.invm.InVMAcceptor;
import org.hornetq.core.remoting.impl.invm.InVMConnection;
import org.hornetq.core.remoting.impl.invm.InVMRegistry;
import org.hornetq.spi.core.protocol.ProtocolType;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.spi.core.remoting.Connector;
import org.hornetq.utils.ConfigurationHelper;
import org.hornetq.utils.OrderedExecutorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InVMConnector
implements Connector {
    public static final Logger log = Logger.getLogger(InVMConnector.class);
    public static volatile boolean failOnCreateConnection;
    public static volatile int numberOfFailures;
    private static volatile int failures;
    protected final int id;
    private final BufferHandler handler;
    private final ConnectionLifeCycleListener listener;
    private final InVMAcceptor acceptor;
    private final ConcurrentMap<String, Connection> connections = new ConcurrentHashMap<String, Connection>();
    private volatile boolean started;
    protected final OrderedExecutorFactory executorFactory;
    private final Executor closeExecutor;

    public static synchronized void resetFailures() {
        failures = 0;
        failOnCreateConnection = false;
        numberOfFailures = -1;
    }

    private static synchronized void incFailures() {
        if (++failures == numberOfFailures) {
            InVMConnector.resetFailures();
        }
    }

    public InVMConnector(Map<String, Object> configuration, BufferHandler handler, ConnectionLifeCycleListener listener, Executor closeExecutor, Executor threadPool) {
        this.listener = listener;
        this.id = ConfigurationHelper.getIntProperty("server-id", 0, configuration);
        this.handler = handler;
        this.closeExecutor = closeExecutor;
        this.executorFactory = new OrderedExecutorFactory(threadPool);
        InVMRegistry registry = InVMRegistry.instance;
        this.acceptor = registry.getAcceptor(this.id);
    }

    public Acceptor getAcceptor() {
        return this.acceptor;
    }

    @Override
    public synchronized void close() {
        if (!this.started) {
            return;
        }
        for (Connection connection : this.connections.values()) {
            this.listener.connectionDestroyed(connection.getID());
        }
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public Connection createConnection() {
        if (failOnCreateConnection) {
            InVMConnector.incFailures();
            log.debug("Returning null on InVMConnector for tests");
            return null;
        }
        Connection conn = this.internalCreateConnection(this.acceptor.getHandler(), new Listener(), this.acceptor.getExecutorFactory().getExecutor());
        this.acceptor.connect((String)conn.getID(), this.handler, this, this.executorFactory.getExecutor());
        return conn;
    }

    @Override
    public synchronized void start() {
        this.started = true;
    }

    public BufferHandler getHandler() {
        return this.handler;
    }

    public void disconnect(String connectionID) {
        if (!this.started) {
            return;
        }
        Connection conn = (Connection)this.connections.get(connectionID);
        if (conn != null) {
            conn.close();
        }
    }

    protected Connection internalCreateConnection(BufferHandler handler, ConnectionLifeCycleListener listener, Executor serverExecutor) {
        return new InVMConnection(null, this.id, handler, listener, serverExecutor);
    }

    static {
        numberOfFailures = -1;
    }

    private class Listener
    implements ConnectionLifeCycleListener {
        private Listener() {
        }

        public void connectionCreated(Acceptor acceptor, Connection connection, ProtocolType protocol) {
            if (InVMConnector.this.connections.putIfAbsent((String)connection.getID(), connection) != null) {
                throw new IllegalArgumentException("Connection already exists with id " + connection.getID());
            }
            InVMConnector.this.listener.connectionCreated(acceptor, connection, protocol);
        }

        public void connectionDestroyed(final Object connectionID) {
            if (InVMConnector.this.connections.remove(connectionID) != null) {
                InVMConnector.this.acceptor.disconnect((String)connectionID);
                InVMConnector.this.closeExecutor.execute(new Runnable(){

                    public void run() {
                        InVMConnector.this.listener.connectionDestroyed(connectionID);
                    }
                });
            }
        }

        public void connectionException(final Object connectionID, final HornetQException me) {
            InVMConnector.this.closeExecutor.execute(new Runnable(){

                public void run() {
                    InVMConnector.this.listener.connectionException(connectionID, me);
                }
            });
        }

        public void connectionReadyForWrites(Object connectionID, boolean ready) {
        }
    }
}

