/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.logging.Logger;
import org.hornetq.utils.PasswordMaskingUtil;
import org.hornetq.utils.SensitiveDataCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationHelper {
    public static final Logger log = Logger.getLogger(ConfigurationHelper.class);

    public static String getStringProperty(String propName, String def, Map<String, Object> props) {
        if (props == null) {
            return def;
        }
        Object prop = props.get(propName);
        if (prop == null) {
            return def;
        }
        if (!(prop instanceof String)) {
            return prop.toString();
        }
        return (String)prop;
    }

    public static int getIntProperty(String propName, int def, Map<String, Object> props) {
        if (props == null) {
            return def;
        }
        Object prop = props.get(propName);
        if (prop == null) {
            return def;
        }
        if (prop instanceof String) {
            return Integer.valueOf((String)prop);
        }
        if (!(prop instanceof Number)) {
            log.warn("Property " + propName + " must be an Integer, it is " + prop.getClass().getName());
            return def;
        }
        return ((Number)prop).intValue();
    }

    public static long getLongProperty(String propName, long def, Map<String, Object> props) {
        if (props == null) {
            return def;
        }
        Object prop = props.get(propName);
        if (prop == null) {
            return def;
        }
        if (prop instanceof String) {
            return Long.valueOf((String)prop);
        }
        if (!(prop instanceof Number)) {
            log.warn("Property " + propName + " must be an Long, it is " + prop.getClass().getName());
            return def;
        }
        return ((Number)prop).longValue();
    }

    public static boolean getBooleanProperty(String propName, boolean def, Map<String, Object> props) {
        if (props == null) {
            return def;
        }
        Object prop = props.get(propName);
        if (prop == null) {
            return def;
        }
        if (prop instanceof String) {
            return Boolean.valueOf((String)prop);
        }
        if (!(prop instanceof Boolean)) {
            log.warn("Property " + propName + " must be a Boolean, it is " + prop.getClass().getName());
            return def;
        }
        return (Boolean)prop;
    }

    public static Set<String> checkKeys(Set<String> allowableKeys, Set<String> keys) {
        HashSet<String> invalid = new HashSet<String>();
        for (String key : keys) {
            if (allowableKeys.contains(key)) continue;
            invalid.add(key);
        }
        return invalid;
    }

    public static Set<String> checkKeysExist(Set<String> requiredKeys, Set<String> keys) {
        HashSet<String> invalid = new HashSet<String>(requiredKeys);
        for (String key : keys) {
            if (!requiredKeys.contains(key)) continue;
            invalid.remove(key);
        }
        return invalid;
    }

    public static String stringSetToCommaListString(String msg, Set<String> invalid) {
        StringBuilder sb = new StringBuilder();
        sb.append(msg);
        int count = 0;
        for (String key : invalid) {
            sb.append(key);
            if (count != invalid.size() - 1) {
                sb.append(", ");
            }
            ++count;
        }
        return sb.toString();
    }

    public static String getPasswordProperty(String propName, String def, Map<String, Object> props) {
        if (props == null) {
            return def;
        }
        Object prop = props.get(propName);
        if (prop == null) {
            return def;
        }
        String value = prop.toString();
        Boolean useMask = (Boolean)props.get("hornetq.usemaskedpassword");
        if (useMask == null || !useMask.booleanValue()) {
            return value;
        }
        String classImpl = (String)props.get("hornetq.passwordcodec");
        if (classImpl == null) {
            throw new IllegalArgumentException("No available codec to decode password!");
        }
        SensitiveDataCodec<String> codec = null;
        try {
            codec = PasswordMaskingUtil.getCodec(classImpl);
        }
        catch (HornetQException e1) {
            throw new IllegalArgumentException("Failed to get decoder", e1);
        }
        try {
            return codec.decode(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error decoding password", e);
        }
    }
}

