/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.distdiff.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class DistDiffInspector
extends JFrame {
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTree jTree1;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private MutableTreeNode treeRoot;
    private MutableTreeNode allNode;
    private MutableTreeNode unexpectedNode;
    private MutableTreeNode expectedNotFoundNode;

    public DistDiffInspector() {
        this.initComponents();
        this.initTree();
        this.jTree1.expandRow(0);
    }

    private void initTree() {
        this.treeRoot = new DefaultMutableTreeNode("Dist-diff result");
        this.jTree1.setModel(new DefaultTreeModel(this.treeRoot));
        this.allNode = new DefaultMutableTreeNode("All differences");
        this.unexpectedNode = new DefaultMutableTreeNode("Unexpected differences");
        this.expectedNotFoundNode = new DefaultMutableTreeNode("Expected differences not found");
        ((DefaultMutableTreeNode)this.treeRoot).add(this.allNode);
        ((DefaultMutableTreeNode)this.treeRoot).add(this.unexpectedNode);
        ((DefaultMutableTreeNode)this.treeRoot).add(this.expectedNotFoundNode);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Dist-diff Result Inspector");
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setPreferredSize(new Dimension(300, 363));
        this.jScrollPane1.setViewportView(this.jTree1);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.fileMenu.setText("File");
        this.openMenuItem.setText("Open");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DistDiffInspector.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DistDiffInspector.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser jfch = new JFileChooser();
        jfch.setDialogTitle("Select dist-diff result file...");
        if (jfch.showOpenDialog(this) == 0) {
            BufferedReader br = null;
            this.initTree();
            Differences differences = Differences.ALL;
            try {
                while (differences != Differences.END) {
                    String line;
                    String headline = "";
                    DefaultMutableTreeNode root = null;
                    switch (differences) {
                        case ALL: {
                            headline = ".*Differences found.*";
                            root = (DefaultMutableTreeNode)this.allNode;
                            break;
                        }
                        case UNEXPECTED: {
                            headline = ".*Unexpected differences found.*";
                            root = (DefaultMutableTreeNode)this.unexpectedNode;
                            break;
                        }
                        case EXPECTED_NOT_FOUND: {
                            headline = ".*Expected differences not found.*";
                            root = (DefaultMutableTreeNode)this.expectedNotFoundNode;
                        }
                    }
                    State state = State.BEGIN;
                    DefaultMutableTreeNode addNode = new DefaultMutableTreeNode("Additions");
                    DefaultMutableTreeNode removeNode = new DefaultMutableTreeNode("Removals");
                    DefaultMutableTreeNode modNode = new DefaultMutableTreeNode("Modifications");
                    root.add(addNode);
                    root.add(removeNode);
                    root.add(modNode);
                    br = new BufferedReader(new FileReader(jfch.getSelectedFile()));
                    while ((line = br.readLine()) != null) {
                        switch (state) {
                            case BEGIN: {
                                if (!line.matches(headline)) break;
                                state = State.PRE_ADDITION;
                                break;
                            }
                            case PRE_ADDITION: {
                                if (!line.matches(".*Additions.*")) break;
                                state = State.ADDITION;
                                break;
                            }
                            case ADDITION: {
                                if (line.matches(".*Removals.*")) {
                                    state = State.REMOVAL;
                                    break;
                                }
                                if (!line.matches("\\Wdist-diff\\W\\s{3}.*")) break;
                                this.joinRecord(addNode, this.modLine(line, differences));
                                break;
                            }
                            case REMOVAL: {
                                if (line.matches(".*Modifications.*")) {
                                    state = State.MODIFICATION;
                                    break;
                                }
                                if (!line.matches("\\Wdist-diff\\W\\s{3}.*")) break;
                                this.joinRecord(removeNode, this.modLine(line, differences));
                                break;
                            }
                            case MODIFICATION: {
                                if (line.matches("\\Wdist-diff\\W\\s{3}.*")) {
                                    this.joinRecord(modNode, this.modLine(line, differences));
                                    break;
                                }
                                state = State.END;
                                break;
                            }
                        }
                    }
                    switch (differences) {
                        case ALL: {
                            differences = Differences.UNEXPECTED;
                            break;
                        }
                        case UNEXPECTED: {
                            differences = Differences.EXPECTED_NOT_FOUND;
                            break;
                        }
                        case EXPECTED_NOT_FOUND: {
                            differences = Differences.END;
                        }
                    }
                }
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            this.treeRoot.setUserObject(jfch.getSelectedFile());
            for (int i = 0; i < this.jTree1.getRowCount(); ++i) {
                this.jTree1.expandRow(i);
            }
        }
    }

    private String modLine(String line, Differences tState) {
        String l = line.toString();
        l = l.replaceAll("\\[dist-diff\\]", "").trim();
        if (tState == Differences.EXPECTED_NOT_FOUND) {
            l = l.replaceAll("\\(expected\\)", "").trim();
        }
        return l;
    }

    private void joinRecord(DefaultMutableTreeNode root, String record) {
        StringTokenizer st = new StringTokenizer(record, "/");
        DefaultMutableTreeNode currentRoot = root;
        block0: while (st.hasMoreTokens()) {
            String token = st.nextToken();
            for (int i = 0; i < currentRoot.getChildCount(); ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)currentRoot.getChildAt(i);
                if (!node.getUserObject().equals(token)) continue;
                currentRoot = node;
                continue block0;
            }
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(token);
            currentRoot.add(child);
            currentRoot = child;
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new DistDiffInspector().setVisible(true);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Differences {
        ALL,
        UNEXPECTED,
        EXPECTED_NOT_FOUND,
        END;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        BEGIN,
        PRE_ADDITION,
        ADDITION,
        REMOVAL,
        MODIFICATION,
        END;

    }
}

