/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.services.security;

import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.services.security.SecurityServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PrivateCryptoUtil {
    INSTANCE;

    private Logger log;
    private Cipher cipher;
    private SecretKey secretKey;

    private PrivateCryptoUtil() {
        try {
            this.log = PrivateCryptoUtil.getLogger();
            this.initSecretKey();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SealedObject sealObject(Serializable serializable) throws SecurityServiceException {
        AssertArgument.isNotNull(serializable, "serializable");
        try {
            Cipher cipher = this.cipher;
            synchronized (cipher) {
                this.cipher.init(1, this.secretKey);
                return new SealedObject(serializable, this.cipher);
            }
        }
        catch (InvalidKeyException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable unSealObject(SealedObject sealedObject) throws SecurityServiceException {
        AssertArgument.isNotNull(sealedObject, "sealedObject");
        try {
            Cipher cipher = this.cipher;
            synchronized (cipher) {
                this.cipher.init(2, this.secretKey);
                return (Serializable)sealedObject.getObject(this.cipher);
            }
        }
        catch (InvalidKeyException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
    }

    private void initSecretKey() throws SecurityServiceException {
        try {
            int keySize;
            String algorithm = Configuration.getSecurityServiceSealAlgorithm();
            if (algorithm == null) {
                throw new SecurityServiceException("'org.jboss.soa.esb.services.security.sealAlgorithm' has not been configured. Please set the algorithm to use in jbossesb-properties.xml");
            }
            String keySizeStr = Configuration.getSecurityServiceSealKeySize();
            if (keySizeStr == null) {
                throw new SecurityServiceException("'org.jboss.soa.esb.services.security.sealKeySize' has not been configured. Please set the key size to use in jbossesb-properties.xml");
            }
            try {
                keySize = Integer.parseInt(keySizeStr.trim());
            }
            catch (NumberFormatException e) {
                throw new SecurityServiceException("'org.jboss.soa.esb.services.security.sealKeySize' must be a number. Please set the key size correctly in jbossesb-properties.xml");
            }
            this.log.debug((Object)("SealAlgorithm '" + algorithm + "' keySize '" + keySize + "'"));
            KeyGenerator kpg = KeyGenerator.getInstance(algorithm);
            kpg.init(keySize);
            this.secretKey = kpg.generateKey();
            this.cipher = Cipher.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (NoSuchPaddingException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
    }

    private static Logger getLogger() {
        return Logger.getLogger(PrivateCryptoUtil.class);
    }
}

