/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.routing.email;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.Email;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.message.Properties;

public class Emailer {
    private Logger log = Logger.getLogger(Emailer.class);
    private static final String MESSAGE_ATTACHMENT_NAME = "msgAttachmentName";
    private MessagePayloadProxy payloadProxy;
    private ConfigTree config;

    public Emailer(ConfigTree config) throws ConfigurationException {
        this.config = config;
        this.checkValidAddress(config.getAttribute("from"), true);
        this.checkValidAddress(config.getAttribute("sendTo"), false);
        this.checkValidAddress(config.getAttribute("ccTo"), true);
        this.payloadProxy = new MessagePayloadProxy(config);
    }

    public void sendEmail(Message message) throws MessageDeliverException {
        ConfigTree configTree = this.config.cloneObj();
        Emailer.overrideSmtpProperties(message, configTree);
        Object obj = this.payloadProxy.getPayload(message);
        this.sendEmail(configTree, obj);
    }

    public void sendEmail(Object obj) throws MessageDeliverException {
        this.sendEmail(this.config, obj);
    }

    public void sendEmail(ConfigTree config, Object obj) throws MessageDeliverException {
        try {
            byte[] payloadBytes;
            String content;
            if (obj instanceof byte[]) {
                content = new String((byte[])obj);
                payloadBytes = (byte[])((byte[])obj).clone();
            } else {
                content = obj.toString();
                payloadBytes = content.getBytes();
            }
            ConfigTree configTree = config.cloneObj();
            String sMsg = configTree.getAttribute("message");
            sMsg = null == sMsg ? content : sMsg + "\n" + content;
            configTree.setAttribute("message", sMsg);
            this.sendEmail(configTree, payloadBytes);
        }
        catch (AddressException e) {
            this.log.error((Object)"Send Mail Failed", (Throwable)e);
            throw new MessageDeliverException("AddressException while trying to send email", e);
        }
        catch (MessagingException e) {
            throw new MessageDeliverException("MessageingException while trying to send email", e);
        }
        catch (IOException e) {
            this.log.error((Object)"Send Mail Failed", (Throwable)e);
            throw new MessageDeliverException("IOException while trying to send email", e);
        }
    }

    protected void sendEmail(ConfigTree messageParams, byte[] msgPayload) throws AddressException, MessagingException, IOException {
        Email esbMail = this.createEmailInstance(messageParams);
        esbMail.setSendTo(messageParams.getAttribute("sendTo"));
        esbMail.setFrom(messageParams.getAttribute("from"));
        esbMail.setCopyTo(messageParams.getAttribute("ccTo"));
        esbMail.setSubject(messageParams.getAttribute("subject"));
        esbMail.setAttachments(messageParams.getTextChildren("attachment"));
        if (messageParams.getAttribute(MESSAGE_ATTACHMENT_NAME) != null) {
            esbMail.addAttachment(new ByteArrayInputStream(msgPayload), messageParams.getAttribute(MESSAGE_ATTACHMENT_NAME));
        } else {
            esbMail.setMessage(messageParams.getAttribute("message"));
        }
        esbMail.sendMessage();
    }

    public static void overrideSmtpProperties(Message message, ConfigTree configTree) {
        Properties properties = message.getProperties();
        Emailer.override("host", properties, configTree);
        Emailer.override("port", properties, configTree);
        Emailer.override("username", properties, configTree);
        Emailer.override("password", properties, configTree);
        Emailer.override("auth", properties, configTree);
        Emailer.override("from", properties, configTree);
        Emailer.override("sendTo", properties, configTree);
        Emailer.override("ccTo", properties, configTree);
        Emailer.override("subject", properties, configTree);
        Emailer.override(MESSAGE_ATTACHMENT_NAME, properties, configTree);
    }

    private void checkValidAddress(String address, boolean optional) throws ConfigurationException {
        if (address == null && optional) {
            return;
        }
        try {
            InternetAddress.parse((String)address);
        }
        catch (AddressException e) {
            throw new ConfigurationException(address + " is not valid", e);
        }
    }

    private static void override(String key, Properties properties, ConfigTree configTree) {
        String value = (String)properties.getProperty(key);
        if (value != null) {
            configTree.setAttribute(key, value);
        }
    }

    private Email createEmailInstance(ConfigTree configTree) throws AddressException, MessagingException {
        int port;
        String portStr = configTree.getAttribute("port");
        if (portStr == null) {
            portStr = Configuration.getSmtpPort();
        }
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            throw new MessagingException("Could not parse port '" + portStr + "'");
        }
        String host = configTree.getAttribute("host", Configuration.getSmtpHost());
        String username = configTree.getAttribute("username", Configuration.getSmtpUsername());
        String password = configTree.getAttribute("password", Configuration.getSmtpPassword());
        boolean auth = configTree.getBooleanAttribute("auth", false);
        return new Email(host, port, username, password, auth);
    }
}

