/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.addressing.eprs;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.PortReference;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FileEpr
extends EPR {
    public static final String INPUT_SUFFIX_TAG = "inputSuffix";
    public static final String WORK_SUFFIX_TAG = "workSuffix";
    public static final String POST_DIR_TAG = "postDir";
    public static final String POST_SUFFIX_TAG = "postSuffix";
    public static final String POST_DEL_TAG = "postDelete";
    public static final String POST_RENAME_TAG = "postRename";
    public static final String ERROR_DIR_TAG = "errorDir";
    public static final String ERROR_SUFFIX_TAG = "errorSuffix";
    public static final String ERROR_DEL_TAG = "errorDelete";
    public static final String URL_TAG = "URL";
    public static final String DEFAULT_REPLY_TO_FILE_SUFFIX = "_reply";
    private boolean inputSet = false;
    private boolean workSet = false;
    private boolean postDirSet = false;
    private boolean postSuffixSet = false;
    private boolean postDelSet = false;
    private boolean postRenameSet = false;
    private boolean errorDirSet = false;
    private boolean errorSuffixSet = false;
    private boolean errorDelSet = false;
    private static URI _type;

    public FileEpr(EPR epr) {
        super(epr);
        if (epr instanceof FileEpr) {
            FileEpr instance = (FileEpr)epr;
            this.inputSet = instance.inputSet;
            this.workSet = instance.workSet;
            this.postDirSet = instance.postDirSet;
            this.postSuffixSet = instance.postSuffixSet;
            this.postDelSet = instance.postDelSet;
            this.postRenameSet = instance.postRenameSet;
            this.errorDirSet = instance.errorDirSet;
            this.errorSuffixSet = instance.errorSuffixSet;
            this.errorDelSet = instance.errorDelSet;
        }
    }

    public FileEpr(EPR epr, Element header) {
        super(epr);
        NodeList nl = header.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            try {
                String content;
                String prefix = nl.item(i).getPrefix();
                String tag = nl.item(i).getLocalName();
                if (prefix == null || !prefix.equals("jbossesb") || tag == null) continue;
                if (tag.equals(POST_RENAME_TAG)) {
                    content = nl.item(i).getTextContent();
                    if ("null".equals(content)) {
                        this.setPostRename(true);
                    } else {
                        this.setPostRename("true".equalsIgnoreCase(content));
                    }
                }
                if (tag.equals(INPUT_SUFFIX_TAG)) {
                    this.setInputSuffix(nl.item(i).getTextContent());
                    continue;
                }
                if (tag.equals(POST_DIR_TAG)) {
                    this.setPostDirectory(nl.item(i).getTextContent());
                    continue;
                }
                if (tag.equals(POST_SUFFIX_TAG)) {
                    this.setPostSuffix(nl.item(i).getTextContent());
                    continue;
                }
                if (tag.equals(POST_DEL_TAG)) {
                    content = nl.item(i).getTextContent();
                    if ("true".equalsIgnoreCase(content)) {
                        this.setPostDelete(true);
                        continue;
                    }
                    if (!"false".equalsIgnoreCase(content)) continue;
                    this.setPostDelete(false);
                    continue;
                }
                if (tag.equals(ERROR_DIR_TAG)) {
                    this.setErrorDirectory(nl.item(i).getTextContent());
                    continue;
                }
                if (tag.equals(ERROR_SUFFIX_TAG)) {
                    this.setErrorSuffix(nl.item(i).getTextContent());
                    continue;
                }
                if (!tag.equals(ERROR_DEL_TAG)) continue;
                content = nl.item(i).getTextContent();
                if ("true".equalsIgnoreCase(content)) {
                    this.setErrorDelete(true);
                    continue;
                }
                if (!"false".equalsIgnoreCase(content)) continue;
                this.setErrorDelete(false);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public FileEpr(URL url) throws URISyntaxException {
        this(url.toURI());
    }

    public FileEpr(String url) throws URISyntaxException {
        super(new URI(url));
    }

    public void setURL(URL url) {
        super.setAddr(new PortReference(url.toString()));
    }

    public URL getURL() {
        try {
            return new URL(super.getAddr().getAddress());
        }
        catch (Exception ex) {
            _logger.warn((Object)"Unexpected parsing exception!", (Throwable)ex);
            return null;
        }
    }

    public final void setInputSuffix(String suffix) throws URISyntaxException {
        if (suffix == null) {
            throw new IllegalArgumentException();
        }
        if (this.inputSet) {
            throw new IllegalStateException("Input suffix already set.");
        }
        this.getAddr().addExtension(INPUT_SUFFIX_TAG, suffix);
        this.inputSet = true;
    }

    public final String getInputSuffix() {
        return this.getAddr().getExtensionValue(INPUT_SUFFIX_TAG);
    }

    public final void setWorkSuffix(String suffix) throws URISyntaxException {
        if (suffix == null) {
            throw new IllegalArgumentException();
        }
        if (this.workSet) {
            throw new IllegalStateException("Cannot change work suffix");
        }
        this.getAddr().addExtension(WORK_SUFFIX_TAG, suffix);
        this.workSet = true;
    }

    public final String getWorkSuffix() {
        return this.getAddr().getExtensionValue(WORK_SUFFIX_TAG);
    }

    public final void setPostDirectory(String dir) throws URISyntaxException {
        if (dir == null) {
            throw new IllegalArgumentException();
        }
        if (this.postDirSet) {
            throw new IllegalStateException("Cannot change post directory");
        }
        this.getAddr().addExtension(POST_DIR_TAG, dir);
        this.postDirSet = true;
    }

    public final String getPostDirectory() {
        return this.getAddr().getExtensionValue(POST_DIR_TAG);
    }

    public final void setPostSuffix(String suffix) throws URISyntaxException {
        if (suffix == null) {
            throw new IllegalArgumentException();
        }
        if (this.postSuffixSet) {
            throw new IllegalStateException("Cannot change post suffix");
        }
        this.getAddr().addExtension(POST_SUFFIX_TAG, suffix);
        this.postSuffixSet = true;
    }

    public final String getPostSuffix() {
        return this.getAddr().getExtensionValue(POST_SUFFIX_TAG);
    }

    public final void setPostDelete(boolean del) throws URISyntaxException {
        if (this.postDelSet) {
            throw new IllegalStateException("Cannot change post delete");
        }
        if (del) {
            this.getAddr().addExtension(POST_DEL_TAG, "true");
        } else {
            this.getAddr().addExtension(POST_DEL_TAG, "false");
        }
        this.postDelSet = true;
    }

    public final void setPostRename(boolean rename) throws URISyntaxException {
        if (this.postRenameSet) {
            throw new IllegalStateException("Cannot change post rename");
        }
        this.getAddr().addExtension(POST_RENAME_TAG, Boolean.toString(rename));
        this.postRenameSet = true;
    }

    public final boolean getPostRename() {
        return "true".equals(this.getAddr().getExtensionValue(POST_RENAME_TAG));
    }

    public final boolean getPostDelete() {
        return "true".equals(this.getAddr().getExtensionValue(POST_DEL_TAG));
    }

    public final void setErrorDirectory(String dir) throws URISyntaxException {
        if (dir == null) {
            throw new IllegalArgumentException();
        }
        if (this.errorDirSet) {
            throw new IllegalStateException("Cannot change error directory");
        }
        this.getAddr().addExtension(ERROR_DIR_TAG, dir);
        this.errorDirSet = true;
    }

    public final String getErrorDirectory() {
        return this.getAddr().getExtensionValue(ERROR_DIR_TAG);
    }

    public final void setErrorSuffix(String suffix) throws URISyntaxException {
        if (suffix == null) {
            throw new IllegalArgumentException();
        }
        if (this.errorSuffixSet) {
            throw new IllegalStateException("Cannot change error suffix");
        }
        this.getAddr().addExtension(ERROR_SUFFIX_TAG, suffix);
        this.errorSuffixSet = true;
    }

    public final String getErrorSuffix() {
        return this.getAddr().getExtensionValue(ERROR_SUFFIX_TAG);
    }

    public final void setErrorDelete(boolean del) throws URISyntaxException {
        if (this.errorDelSet) {
            throw new IllegalStateException("Cannot change error delete");
        }
        if (del) {
            this.getAddr().addExtension(ERROR_DEL_TAG, "true");
        } else {
            this.getAddr().addExtension(ERROR_DEL_TAG, "false");
        }
        this.errorDelSet = true;
    }

    public final boolean getErrorDelete() {
        return !"false".equals(this.getAddr().getExtensionValue(ERROR_DEL_TAG));
    }

    public String toString() {
        return "FileEpr [ " + super.getAddr().extendedToString() + " ]";
    }

    public EPR copy() {
        return new FileEpr(this);
    }

    public static URI type() {
        return _type;
    }

    public FileEpr(URI uri) {
        super(uri);
    }

    static {
        try {
            _type = new URI("urn:jboss/esb/epr/type/file");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex.toString());
        }
    }
}

