/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.helpers.persist;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDataSource
implements DataSource {
    private PrintWriter m_oPW = new PrintWriter(System.out);
    private int m_iTO = 10;
    private String m_sUrl;
    private String m_sUsr;
    private String m_sPwd;
    private Connection m_oConn;
    public static final String DRIVER = "driver-class";
    public static final String URL = "connection-url";
    public static final String USER = "user-name";
    public static final String PASSWORD = "password";
    private static final Logger _logger = Logger.getLogger(SimpleDataSource.class);

    private SimpleDataSource() {
    }

    public SimpleDataSource(ConfigTree p_oP) {
        this(p_oP.getAttribute(DRIVER), p_oP.getAttribute(URL), p_oP.getAttribute(USER), p_oP.getAttribute(PASSWORD));
    }

    public SimpleDataSource(String p_sDriver, String p_sDbURL, String p_sUsr, String p_sPwd) {
        try {
            ClassUtil.forName(p_sDriver, this.getClass());
            this.m_sUrl = p_sDbURL;
            this.getConnection(p_sUsr, p_sPwd);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.m_oConn == null || this.m_oConn.isClosed()) {
            this.m_oConn = this.getConnection(this.m_sUsr, this.m_sPwd);
        }
        if (this.m_oConn == null) {
            throw new SQLException();
        }
        return this.m_oConn;
    }

    @Override
    public Connection getConnection(String username, String password) {
        this.m_sUsr = username;
        this.m_sPwd = password;
        try {
            this.m_oConn = DriverManager.getConnection(this.m_sUrl, this.m_sUsr, this.m_sPwd);
        }
        catch (Exception e) {
            _logger.error((Object)("Could not create connection for " + this.m_sUrl + " - datasource may be unavailable.  " + "See server log for details."));
            _logger.debug((Object)"Can't obtain datasource", (Throwable)e);
            this.m_oConn = null;
        }
        return this.m_oConn;
    }

    @Override
    public int getLoginTimeout() {
        return this.m_iTO;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.m_oPW;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this.m_iTO = seconds;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        this.m_oPW = out;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("unwrap method not supported by this implementation");
    }
}

