/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.http;

import java.util.regex.Pattern;
import org.jboss.soa.esb.common.ModulePropertyManager;

public abstract class HttpContentTypeUtil {
    private static Pattern[] textMimePatterns;

    public static boolean isTextMimetype(String contentType) {
        if (contentType == null) {
            return false;
        }
        for (int i = 0; i < textMimePatterns.length; ++i) {
            if (!textMimePatterns[i].matcher(contentType).matches()) continue;
            return true;
        }
        return false;
    }

    static {
        String[] textTypes = ModulePropertyManager.getPropertyManager("core").getProperty("org.jboss.soa.esb.mime.text.types", "text/*;application/xml;application/*-xml").split(";");
        textMimePatterns = new Pattern[textTypes.length];
        for (int i = 0; i < textMimePatterns.length; ++i) {
            HttpContentTypeUtil.textMimePatterns[i] = Pattern.compile(textTypes[i].trim().replace("*", ".*"));
        }
    }
}

