/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.mappers110;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.mappers110.MapperUtil;
import org.jboss.soa.esb.listeners.config.mappers110.XMLBeansModel;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.Bus;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.Listener;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.SqlBusDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.SqlListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.SqlMessageFilterDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.SqlProviderDocument;
import org.jboss.soa.esb.listeners.gateway.SqlTableGatewayListener;
import org.w3c.dom.Element;

public class SqlListenerMapper {
    public static Element map(Element root, SqlListenerDocument.SqlListener listener, XMLBeansModel model) throws ConfigurationException {
        SqlMessageFilterDocument.SqlMessageFilter messageFilter;
        SqlProviderDocument.SqlProvider provider;
        SqlBusDocument.SqlBus bus;
        Element listenerNode = YADOMUtil.addElement(root, "listener");
        listenerNode.setAttribute("name", listener.getName());
        try {
            bus = (SqlBusDocument.SqlBus)model.getBus(listener.getBusidref());
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Invalid busid reference [" + listener.getBusidref() + "] on listener [" + listener.getName() + "].  A <sql-listener> must reference a <sql-bus>.");
        }
        try {
            provider = (SqlProviderDocument.SqlProvider)model.getProvider((Bus)bus);
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Invalid bus config [" + listener.getBusidref() + "].  Should be contained within a <sql-provider> instance.  Unexpected exception - this should have caused a validation error!");
        }
        if (provider.getDatasource() != null) {
            if (provider.getUsername() != null || provider.getDriver() != null) {
                throw new ConfigurationException("Invalid sql-provider configuration : a datasource and a username/password/driver combination cannot both be defined.   Use only one (datasource or JDBC connection info).Datasource : [" + provider.getDatasource() + "] JDBC URL [" + provider.getUrl() + "]");
            }
        } else {
            if (provider.getUrl() == null) {
                throw new ConfigurationException("Invalid sql-provider configuration : a datasource or a URL/username/password/driver combination must be defined.   Use only one (datasource or JDBC connection info).  URL was null.");
            }
            if (provider.getUsername() == null) {
                throw new ConfigurationException("Invalid sql-provider configuration :  a datasource or a URL/username/password/driver combination must be defined.   Use only one (datasource or JDBC connection info).   Username was null.");
            }
            if (provider.getDriver() == null) {
                throw new ConfigurationException("Invalid sql-provider configuration : either a datasource or a URL/username/password/driver combination must be defined.   Use only one (datasource or JDBC connection info).   Driver was null.");
            }
        }
        if ((messageFilter = listener.getSqlMessageFilter()) == null && (messageFilter = bus.getSqlMessageFilter()) == null) {
            throw new ConfigurationException("No <sql-destination> defined on either <sql-listener> [" + listener.getName() + "] or <sql-bus> [" + bus.getBusid() + "].");
        }
        listenerNode.setAttribute("pollLatencySeconds", String.valueOf(listener.getPollFrequencySeconds()));
        if (provider.isSetTransacted()) {
            listenerNode.setAttribute("transacted", Boolean.toString(provider.getTransacted()));
        }
        MapperUtil.mapDefaultAttributes((Listener)listener, listenerNode, model);
        MapperUtil.mapProperties(listener.getPropertyList(), listenerNode);
        if (listener.getIsGateway()) {
            listenerNode.setAttribute("gatewayClass", SqlTableGatewayListener.class.getName());
            listenerNode.setAttribute("is-gateway", Boolean.toString(listener.getIsGateway()));
            SqlListenerMapper.mapSqlEprProperties(listenerNode, provider, messageFilter);
            MapperUtil.mapEPRProperties((Listener)listener, listenerNode, model);
        } else {
            Element eprNode = YADOMUtil.addElement(listenerNode, "EPR");
            SqlListenerMapper.mapSqlEprProperties(eprNode, provider, messageFilter);
            MapperUtil.mapEPRProperties((Listener)listener, eprNode, model);
            YADOMUtil.removeEmptyAttributes(eprNode);
        }
        YADOMUtil.removeEmptyAttributes(listenerNode);
        return listenerNode;
    }

    private static void mapSqlEprProperties(Element toElement, SqlProviderDocument.SqlProvider provider, SqlMessageFilterDocument.SqlMessageFilter messageFilter) {
        toElement.setAttribute("datasource", provider.getDatasource());
        toElement.setAttribute("URL", provider.getUrl());
        toElement.setAttribute("driver", provider.getDriver());
        toElement.setAttribute("username", provider.getUsername());
        toElement.setAttribute("password", provider.getPassword());
        toElement.setAttribute("tablename", messageFilter.getTablename());
        toElement.setAttribute("whereCondition", messageFilter.getWhereCondition());
        toElement.setAttribute("orderBy", messageFilter.getOrderBy());
        toElement.setAttribute("message_id_column", messageFilter.getMessageIdColumn());
        toElement.setAttribute("message_column", messageFilter.getMessageColumn());
        toElement.setAttribute("status_column", String.valueOf(messageFilter.getStatusColumn()));
        toElement.setAttribute("insert_timestamp_column", messageFilter.getInsertTimestampColumn());
        toElement.setAttribute("postDelete", String.valueOf(messageFilter.getPostDelete()));
        toElement.setAttribute("errorDelete", String.valueOf(messageFilter.getErrorDelete()));
    }
}

