/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.CallbackException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Transaction;
import org.hibernate.type.Type;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerUtil;
import org.jboss.soa.esb.listeners.RegistryUtil;
import org.jboss.soa.esb.listeners.gateway.HibernateEventBean;
import org.jboss.soa.esb.listeners.gateway.PackageHibernateMessageContents;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;
import org.jboss.soa.esb.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateInterceptor
extends EmptyInterceptor {
    private static final long serialVersionUID = 1L;
    private ArrayList<HibernateEventBean> m_events;
    private static final Logger m_logger = Logger.getLogger(HibernateInterceptor.class);
    protected Class m_composerClass;
    protected Method m_processMethod;
    protected Object m_composer;
    protected String m_composerName;
    protected ConfigTree m_config;
    private boolean enabled;
    protected ServiceInvoker m_serviceInvoker;
    protected String m_targetServiceCategory;
    protected String m_targetServiceName;
    private static final String DELETE_EVENT = "onDelete";
    private static final String SAVE_EVENT = "onSave";
    private static final String LOAD_EVENT = "onLoad";
    private static final String FLUSH_DIRTY_EVENT = "onFlushDirty";
    private static final String COLLECTION_UPDATE_EVENT = "onCollectionUpdate";
    private static final String COLLECTION_REMOVE_EVENT = "onCollectionRemove";

    public HibernateInterceptor(ConfigTree f_config, ArrayList<HibernateEventBean> f_list) throws ManagedLifecycleException {
        this.m_config = f_config;
        this.m_events = f_list;
        try {
            this.m_targetServiceCategory = ListenerUtil.getValue(this.m_config, "target-service-category", null);
            this.m_targetServiceName = ListenerUtil.getValue(this.m_config, "target-service-name", null);
            if (this.m_targetServiceCategory == null) {
                throw new ManagedLifecycleException("No target service category defined!");
            }
            if (this.m_targetServiceName == null) {
                throw new ManagedLifecycleException("No target service name defined!");
            }
            List<EPR> _targetEprs = RegistryUtil.getEprs(this.m_targetServiceCategory, this.m_targetServiceName);
            if (null == _targetEprs || _targetEprs.size() < 1) {
                throw new ManagedLifecycleException("EPR <" + this.m_targetServiceName + "> not found in registry");
            }
            this.m_serviceInvoker = new ServiceInvoker(this.m_targetServiceCategory, this.m_targetServiceName);
        }
        catch (ServiceNotFoundException snfe) {
            throw new ManagedLifecycleException("EPR <" + this.m_targetServiceName + " " + this.m_targetServiceName + "> not found in registry");
        }
        catch (RegistryException re) {
            throw new ManagedLifecycleException("Unexpected registry exception", re);
        }
        catch (MessageDeliverException mde) {
            throw new ManagedLifecycleException("EPR <" + this.m_targetServiceName + " " + this.m_targetServiceName + "> not found in registry", mde);
        }
        catch (ManagedLifecycleException ex) {
            throw ex;
        }
        try {
            this.resolveComposerClass();
        }
        catch (ConfigurationException e) {
            throw new ManagedLifecycleException("Problem resolving composer class", e);
        }
    }

    private Message createMessage(Object messageObject) {
        Object obj = null;
        try {
            obj = this.m_processMethod.invoke(this.m_composer, messageObject);
            if (null == obj) {
                m_logger.error((Object)("Action class method <" + this.m_processMethod.getName() + "> returned a null object"));
            }
        }
        catch (IllegalArgumentException e) {
            m_logger.error((Object)"Error creating message", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            m_logger.error((Object)"Error creating message", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            m_logger.error((Object)"Error creating message", (Throwable)e);
        }
        Message message = (Message)obj;
        return message;
    }

    private void addMessageInfo(Message message, Serializable id, Object[] newValues, Object[] oldValues, String[] propertyNames, Type[] types) {
        if (message != null) {
            if (id != null) {
                message.getProperties().setProperty("hibernateInterceptorId", id);
            }
            message.getProperties().setProperty("hibernateInterceptorNewValues", newValues);
            message.getProperties().setProperty("hibernateInterceptorOldValues", oldValues);
            message.getProperties().setProperty("hibernateInterceptorPropertyNames", propertyNames);
            message.getProperties().setProperty("hibernateInterceptorTypes", types);
        }
    }

    private void addMessageInfo(Message message, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (message != null) {
            if (id != null) {
                message.getProperties().setProperty("hibernateInterceptorId", id);
            }
            message.getProperties().setProperty("hibernateInterceptorState", state);
            message.getProperties().setProperty("hibernateInterceptorPropertyNames", propertyNames);
            message.getProperties().setProperty("hibernateInterceptorTypes", types);
        }
    }

    private void deliverMessage(Message message) {
        MessageDeliverException thrown = null;
        String text = null;
        try {
            this.m_serviceInvoker.deliverAsync(message);
        }
        catch (MessageDeliverException e) {
            thrown = e;
            text = "ServiceInvoker <" + this.m_targetServiceCategory + " " + this.m_targetServiceName + ">.deliverAsync(Message) FAILED";
        }
        if (null != thrown) {
            m_logger.error(text);
            m_logger.debug(text, (Throwable)thrown);
        }
    }

    protected void resolveComposerClass() throws ConfigurationException {
        try {
            String sProcessMethod = null;
            this.m_composerName = this.m_config.getAttribute("composer-class");
            if (null != this.m_composerName) {
                this.m_composerClass = ClassUtil.forName(this.m_composerName, ((Object)((Object)this)).getClass());
                Constructor oConst = this.m_composerClass.getConstructor(ConfigTree.class);
                this.m_composer = oConst.newInstance(this.m_config);
                sProcessMethod = this.m_config.getAttribute("composer-process", "process");
            } else {
                this.m_composerName = PackageHibernateMessageContents.class.getName();
                this.m_composerClass = PackageHibernateMessageContents.class;
                this.m_composer = new PackageHibernateMessageContents(PackageHibernateMessageContents.createPayloadProxy(this.m_config));
                sProcessMethod = "process";
                m_logger.debug((Object)("No <action> element found in configuration -  Using default composer class : " + this.m_composerName));
            }
            this.m_processMethod = this.m_composerClass.getMethod(sProcessMethod, Object.class);
        }
        catch (InvocationTargetException ex) {
            m_logger.debug((Object)ex);
            throw new ConfigurationException(ex);
        }
        catch (IllegalAccessException ex) {
            m_logger.debug((Object)ex);
            throw new ConfigurationException(ex);
        }
        catch (InstantiationException ex) {
            m_logger.debug((Object)ex);
            throw new ConfigurationException(ex);
        }
        catch (ClassNotFoundException ex) {
            m_logger.debug((Object)ex);
            throw new ConfigurationException(ex);
        }
        catch (NoSuchMethodException ex) {
            m_logger.debug((Object)ex);
            throw new ConfigurationException(ex);
        }
    }

    public void afterTransactionBegin(Transaction arg0) {
        if (this.isEnabled()) {
            m_logger.debug((Object)"afterTransactionBegin");
        }
    }

    public void afterTransactionCompletion(Transaction arg0) {
        if (this.isEnabled()) {
            m_logger.debug((Object)"afterTransactionCompletion");
        }
    }

    public void beforeTransactionCompletion(Transaction arg0) {
        if (this.isEnabled()) {
            m_logger.debug((Object)"beforeTransactionCompletion");
        }
    }

    public void onCollectionRecreate(Object entity, Serializable id) throws CallbackException {
        if (this.isEnabled()) {
            m_logger.debug((Object)"onCollectionRecreate");
        }
    }

    public void onCollectionRemove(Object entity, Serializable id) throws CallbackException {
        if (this.isEnabled()) {
            m_logger.debug((Object)COLLECTION_REMOVE_EVENT);
            for (HibernateEventBean heb : this.m_events) {
                if (!heb.getEvent().equals(COLLECTION_REMOVE_EVENT) || !entity.getClass().getName().equals(heb.getClassname())) continue;
                Message message = this.createMessage(entity);
                message.getProperties().setProperty("hibernateInterceptorId", id);
                this.deliverMessage(message);
            }
        }
    }

    public void onCollectionUpdate(Object entity, Serializable id) throws CallbackException {
        if (this.isEnabled()) {
            m_logger.debug((Object)COLLECTION_UPDATE_EVENT);
            for (HibernateEventBean heb : this.m_events) {
                if (!heb.getEvent().equals(COLLECTION_UPDATE_EVENT) || !entity.getClass().getName().equals(heb.getClassname())) continue;
                Message message = this.createMessage(entity);
                message.getProperties().setProperty("hibernateInterceptorId", id);
                this.deliverMessage(message);
            }
        }
    }

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        if (this.isEnabled()) {
            m_logger.debug((Object)DELETE_EVENT);
            for (HibernateEventBean heb : this.m_events) {
                if (!heb.getEvent().equals(DELETE_EVENT) || !entity.getClass().getName().equals(heb.getClassname())) continue;
                Message message = this.createMessage(entity);
                this.addMessageInfo(message, id, state, propertyNames, types);
                this.deliverMessage(message);
            }
        }
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] newValues, Object[] oldValues, String[] propertyNames, Type[] types) throws CallbackException {
        if (this.isEnabled()) {
            m_logger.debug((Object)FLUSH_DIRTY_EVENT);
            for (HibernateEventBean heb : this.m_events) {
                if (!heb.getEvent().equals(FLUSH_DIRTY_EVENT) || !entity.getClass().getName().equals(heb.getClassname())) continue;
                Message message = this.createMessage(entity);
                this.addMessageInfo(message, id, newValues, oldValues, propertyNames, types);
                this.deliverMessage(message);
            }
        }
        return false;
    }

    public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        if (this.isEnabled()) {
            m_logger.debug((Object)LOAD_EVENT);
            for (HibernateEventBean heb : this.m_events) {
                if (!heb.getEvent().equals(LOAD_EVENT) || !entity.getClass().getName().equals(heb.getClassname())) continue;
                Message message = this.createMessage(entity);
                this.addMessageInfo(message, id, state, propertyNames, types);
                this.deliverMessage(message);
            }
        }
        return false;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        if (this.isEnabled()) {
            m_logger.debug((Object)SAVE_EVENT);
            for (HibernateEventBean heb : this.m_events) {
                if (!heb.getEvent().equals(SAVE_EVENT) || !entity.getClass().getName().equals(heb.getClassname())) continue;
                Message message = this.createMessage(entity);
                this.addMessageInfo(message, id, state, propertyNames, types);
                this.deliverMessage(message);
            }
        }
        return false;
    }

    public void postFlush(Iterator arg0) throws CallbackException {
        if (this.isEnabled()) {
            m_logger.debug((Object)"postFlush");
        }
    }

    public void preFlush(Iterator arg0) throws CallbackException {
        if (this.isEnabled()) {
            m_logger.debug((Object)"preFlush");
        }
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void enable() {
        this.enabled = true;
    }

    public synchronized void disable() {
        this.enabled = false;
    }
}

