/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway.mina;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.log4j.Logger;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.transport.socket.nio.DatagramAcceptor;
import org.apache.mina.transport.socket.nio.DatagramSessionConfig;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.gateway.mina.MessageHandler;
import org.jboss.soa.esb.listeners.gateway.mina.UdpGatewayConfig;
import org.jboss.soa.esb.listeners.lifecycle.AbstractManagedLifecycle;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;

public class UdpGatewayListener
extends AbstractManagedLifecycle {
    private Logger log = Logger.getLogger(UdpGatewayListener.class);
    private InetSocketAddress socketAddress;
    private IoAcceptor datagramAcceptor;
    private String serviceCategory;
    private String serviceName;
    private MessageHandler messageHandler;

    public UdpGatewayListener(ConfigTree config) throws ConfigurationException {
        super(config);
        UdpGatewayConfig udpConfig = new UdpGatewayConfig(config);
        this.socketAddress = udpConfig.getSocketAddress();
        this.serviceCategory = udpConfig.getServiceCategory();
        this.serviceName = udpConfig.getServiceName();
        this.messageHandler = udpConfig.getHandler();
    }

    protected void doInitialise() throws ManagedLifecycleException {
        ServiceInvoker serviceInvoker = this.createServiceInvoker(this.serviceCategory, this.serviceName);
        this.messageHandler.setServiceInvoker(serviceInvoker);
        this.datagramAcceptor = new DatagramAcceptor();
        ((DatagramSessionConfig)this.datagramAcceptor.getDefaultConfig().getSessionConfig()).setReuseAddress(true);
        try {
            this.datagramAcceptor.bind((SocketAddress)this.socketAddress, (IoHandler)this.messageHandler);
        }
        catch (IOException e) {
            throw new ManagedLifecycleException("IOException while trying to bind UdpListerner to '" + this.socketAddress + "'. Exception was:" + e);
        }
        this.log.info((Object)("Started " + this.toString()));
    }

    protected void doStart() throws ManagedLifecycleException {
    }

    protected void doStop() throws ManagedLifecycleException {
        if (this.socketAddress != null) {
            this.datagramAcceptor.unbind((SocketAddress)this.socketAddress);
        }
        this.log.info((Object)("Stopped " + this.toString()));
    }

    protected void doDestroy() throws ManagedLifecycleException {
    }

    public String toString() {
        return "UdpGatewayListener [address=" + this.socketAddress + ", targetService=" + this.serviceCategory + ":" + this.serviceName + ", messageHandler=" + this.messageHandler + "]";
    }

    private ServiceInvoker createServiceInvoker(String serviceCategory, String serviceName) throws ManagedLifecycleException {
        try {
            return new ServiceInvoker(serviceCategory, serviceName);
        }
        catch (MessageDeliverException e) {
            throw new ManagedLifecycleException(e.getMessage(), e);
        }
    }
}

