/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.message;

import java.lang.reflect.Constructor;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ActionLifecycleException;
import org.jboss.soa.esb.actions.ActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.ActionBeanConfigurator;
import org.jboss.soa.esb.listeners.message.ActionProcessorMethodInfo;
import org.jboss.soa.esb.message.Message;

public class BeanConfigActionProcessor
implements ActionPipelineProcessor {
    private final ConfigTree config;
    private final Constructor constructor;
    private final ActionProcessorMethodInfo methodInfo;

    BeanConfigActionProcessor(ConfigTree config, Class actionClass) throws ConfigurationException {
        AssertArgument.isNotNull(config, "config");
        AssertArgument.isNotNull(actionClass, "actionClass");
        this.config = config;
        try {
            this.constructor = actionClass.getConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            throw new ConfigurationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException(e);
        }
        this.methodInfo = ActionProcessorMethodInfo.getMethodInfo(config, actionClass);
    }

    public Message process(Message message) throws ActionProcessingException {
        if (this.methodInfo.hasProcessMethods()) {
            try {
                Object instance = this.constructor.newInstance(new Object[0]);
                ActionBeanConfigurator configurator = new ActionBeanConfigurator(this.config, instance);
                configurator.configure();
                return this.methodInfo.processMethods(instance, message);
            }
            catch (Exception e) {
                throw new ActionProcessingException(e);
            }
        }
        return message;
    }

    public void processException(Message message, Throwable th) {
    }

    public void processSuccess(Message message) {
    }

    public void destroy() throws ActionLifecycleException {
    }

    public void initialise() throws ActionLifecycleException {
    }
}

