/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.notification;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.notification.NotificationException;
import org.jboss.soa.esb.notification.NotificationTarget;

public class NotificationList
extends ConfigTree {
    private static final long serialVersionUID = 1L;
    public static final String ELEMENT = "NotificationList";
    public static final String TYPE = "type";
    public static final String CHILD_TGT = "target";
    private String m_sType;
    protected static final Logger _logger = Logger.getLogger(NotificationList.class);

    public NotificationList(ConfigTree p_oP) {
        super(p_oP);
        this.m_sType = p_oP.getAttribute(TYPE);
        if (null != this.m_sType) {
            this.m_sType = this.m_sType.toLowerCase();
        }
    }

    private NotificationTarget[] getTargets() throws ConfigurationException {
        ConfigTree[] oaTgts = super.getChildren(CHILD_TGT);
        NotificationTarget[] oaRet = new NotificationTarget[oaTgts.length];
        for (int i1 = 0; i1 < oaRet.length; ++i1) {
            oaRet[i1] = NotificationTarget.fromParams(oaTgts[i1]);
        }
        return oaRet;
    }

    public void sendNotification(Message message) throws NotificationException {
        try {
            NotificationTarget[] oaTgt = this.getTargets();
            for (int i1 = 0; i1 < oaTgt.length; ++i1) {
                oaTgt[i1].sendNotification(message);
            }
        }
        catch (ConfigurationException ex) {
            throw new NotificationException(ex);
        }
    }

    public boolean isOK() {
        return null == this.m_sType ? true : this.m_sType.startsWith("ok");
    }

    public boolean isErr() {
        return null == this.m_sType ? true : this.m_sType.startsWith("err");
    }

    public static void notifyAll(ConfigTree[] list, Message message) {
        for (ConfigTree tree : list) {
            ConfigTree[] targets;
            for (ConfigTree curr : targets = tree.getChildren(CHILD_TGT)) {
                try {
                    NotificationTarget target = NotificationTarget.fromParams(curr);
                    target.sendNotification(message);
                }
                catch (Exception e) {
                    _logger.error((Object)("Can't instantiate target " + curr.toString()), (Throwable)e);
                }
            }
        }
    }
}

