/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.security.plugins.FilePassword;

public final class PasswordUtil {
    private FilePassword filePassword;

    public PasswordUtil(String passwordFile) {
        AssertArgument.isNotNull(passwordFile, "passwordFile");
        this.filePassword = new FilePassword(passwordFile);
    }

    public char[] getPassword() throws IOException {
        return this.filePassword.toCharArray();
    }

    public String getPasswordAsString() throws IOException {
        return new String(this.filePassword.toCharArray());
    }

    public static boolean isPasswordFile(String passwordFile) {
        block4: {
            if (passwordFile == null || "".equals(passwordFile)) {
                return false;
            }
            try {
                URL url = new URL(passwordFile);
                if (url != null) {
                    return true;
                }
            }
            catch (MalformedURLException ignored) {
                File pwFile = new File(passwordFile);
                if (!pwFile.exists() || pwFile.isDirectory()) break block4;
                return true;
            }
        }
        return false;
    }
}

