/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security.auth.ws;

import java.io.IOException;
import java.io.Writer;
import javax.xml.namespace.QName;
import org.milyn.SmooksException;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXElementVisitor;
import org.milyn.delivery.sax.SAXText;
import org.milyn.delivery.sax.SAXVisitor;
import org.milyn.delivery.sax.WriterUtil;
import org.milyn.javabean.decoders.BooleanDecoder;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public abstract class SOAPSecurityHeaderVisitor
implements SAXElementVisitor {
    private static final String HEADER_ADDED = "addedToken";
    private String headerElementName;
    private String headerNS;
    private String securityElementName;
    private String securityNS;
    private String securityPrefix;
    private boolean addSecurityXmlNsAttribute;
    private QName securityQName;
    private QName headerQName;
    private SAXVisitor writerOwner = this;
    private boolean rewriteEntities = true;

    protected abstract String getHeaderToInsert();

    @Initialize
    public void initialize() {
        this.securityQName = new QName(this.securityNS, this.securityElementName, this.securityPrefix);
        this.headerQName = new QName(this.headerNS, this.headerElementName);
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        WriterUtil.writeStartElement((SAXElement)element, (Writer)element.getWriter(this.writerOwner), (boolean)this.rewriteEntities);
    }

    public void onChildText(SAXElement element, SAXText text, ExecutionContext executionContext) throws SmooksException, IOException {
        if (element.isWriterOwner(this.writerOwner)) {
            text.toWriter(element.getWriter(this.writerOwner), this.rewriteEntities);
        }
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        if (element.isWriterOwner(this.writerOwner)) {
            Boolean headerAdded = (Boolean)executionContext.getAttribute((Object)HEADER_ADDED);
            if (headerAdded == null) {
                QName elementQName = element.getName();
                if (elementQName.equals(this.securityQName)) {
                    this.addHeader(element);
                } else if (elementQName.equals(this.headerQName)) {
                    AttributesImpl attributesImpl = new AttributesImpl();
                    if (this.addSecurityXmlNsAttribute) {
                        attributesImpl.addAttribute("", this.securityQName.getLocalPart(), "xmlns:" + this.securityQName.getPrefix(), "CDDATA", this.securityQName.getNamespaceURI());
                    }
                    SAXElement securityElement = new SAXElement(this.securityQName, (Attributes)attributesImpl, element);
                    Writer writer = element.getWriter(this.writerOwner);
                    WriterUtil.writeStartElement((SAXElement)securityElement, (Writer)writer, (boolean)this.rewriteEntities);
                    this.addHeader(element);
                    WriterUtil.writeEndElement((SAXElement)securityElement, (Writer)writer);
                }
                executionContext.setAttribute((Object)HEADER_ADDED, (Object)Boolean.TRUE);
            }
            WriterUtil.writeEndElement((SAXElement)element, (Writer)element.getWriter(this.writerOwner));
        }
    }

    private void addHeader(SAXElement element) throws IOException {
        Writer writer = element.getWriter(this.writerOwner);
        String header = this.getHeaderToInsert();
        if (header != null) {
            writer.append(header);
        }
    }

    public void onChildElement(SAXElement element, SAXElement childElement, ExecutionContext executionContext) throws SmooksException, IOException {
    }

    @ConfigParam(defaultVal="Security")
    public SOAPSecurityHeaderVisitor setSecurityElementName(String securityElementName) {
        this.securityElementName = securityElementName;
        return this;
    }

    @ConfigParam(defaultVal="Header")
    public SOAPSecurityHeaderVisitor setHeaderElementName(String name) {
        this.headerElementName = name;
        return this;
    }

    @ConfigParam(defaultVal="http://schemas.xmlsoap.org/soap/envelope/")
    public SOAPSecurityHeaderVisitor setHeaderNS(String ns) {
        this.headerNS = ns;
        return this;
    }

    @ConfigParam(defaultVal="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")
    public SOAPSecurityHeaderVisitor setSecurityNS(String securityNS) {
        this.securityNS = securityNS;
        return this;
    }

    @ConfigParam(defaultVal="wsse")
    public SOAPSecurityHeaderVisitor setSecurityPrefix(String prefix) {
        this.securityPrefix = prefix;
        return this;
    }

    @ConfigParam(defaultVal="false", decoder=BooleanDecoder.class)
    public SOAPSecurityHeaderVisitor setAddSecurityXmlNSAttribute(boolean add) {
        this.addSecurityXmlNsAttribute = add;
        return this;
    }
}

