/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security.auth.ws;

import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.core.wstrust.SamlCredential;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequestImpl;
import org.jboss.soa.esb.services.security.auth.SecurityInfoExtractor;
import org.jboss.soa.esb.services.security.auth.ws.SOAPExtractorUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamlSoapAssertionExtractor
implements SecurityInfoExtractor<SOAPMessage> {
    private Logger log = Logger.getLogger(SamlSoapAssertionExtractor.class);

    @Override
    public AuthenticationRequest extractSecurityInfo(SOAPMessage soap) {
        if (soap == null) {
            return null;
        }
        Principal user = null;
        HashSet<Object> credentials = new HashSet<Object>();
        try {
            SOAPHeaderElement securityHeader = SOAPExtractorUtil.getSecurityHeader(soap.getSOAPPart().getEnvelope());
            if (securityHeader == null) {
                return null;
            }
            Iterator childElements = securityHeader.getChildElements();
            while (childElements.hasNext()) {
                String localName;
                Node securityNode = (Node)childElements.next();
                if (securityNode.getNodeType() != 1 || !"Assertion".equalsIgnoreCase(localName = securityNode.getLocalName())) continue;
                credentials.add(new SamlCredential((Element)securityNode));
            }
            return new AuthenticationRequestImpl.Builder(user, credentials).build();
        }
        catch (SOAPException e) {
            this.log.error((Object)"Caught a SOAPException while trying to extract security information: ", (Throwable)e);
            throw new SecurityException("Could not extract security info from SOAPMessage");
        }
    }
}

