/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.operation;

import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class NewRequestAction
extends AbstractAction {
    private final WsdlOperation operation;

    public NewRequestAction(WsdlOperation operation) {
        super("New request");
        this.operation = operation;
        this.putValue("ShortDescription", "Creates a new request for this operation");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu N"));
    }

    public void actionPerformed(ActionEvent e) {
        String name = UISupport.prompt("Specify name of request", "New request", "Request " + (this.operation.getRequestCount() + 1));
        if (name == null) {
            return;
        }
        boolean createOptional = this.operation.getSettings().getBoolean(WsdlSettings.XML_GENERATION_ALWAYS_INCLUDE_OPTIONAL_ELEMENTS);
        if (!createOptional) {
            createOptional = UISupport.confirm("Create optional elements in schema?", "Create Request");
        }
        WsdlRequest newRequest = this.operation.addNewRequest(name);
        String requestContent = this.operation.createRequest(createOptional);
        if (requestContent != null) {
            newRequest.setRequestContent(requestContent);
        }
        UISupport.showDesktopPanel(newRequest);
    }
}

