/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.SSLInfo;
import com.eviware.soapui.impl.wsdl.submit.transports.http.TimeablePostMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlUtils;
import org.apache.commons.httpclient.Header;

final class SinglePartHttpResponse
implements WsdlResponse {
    private final WsdlRequest wsdlRequest;
    private final TimeablePostMethod postMethod;
    private long timeTaken;
    private String responseContent;
    private StringToStringMap requestHeaders;
    private StringToStringMap responseHeaders;
    private final String requestContent;
    private boolean prettyPrint;
    private SSLInfo sslInfo;
    private long timestamp;

    public SinglePartHttpResponse(WsdlRequest wsdlRequest, TimeablePostMethod postMethod, String requestContent) {
        this.wsdlRequest = wsdlRequest;
        this.postMethod = postMethod;
        this.requestContent = requestContent;
        this.timeTaken = postMethod.getTimeTaken();
        this.sslInfo = postMethod.getSSLInfo();
        this.timestamp = System.currentTimeMillis();
        Settings settings = wsdlRequest.getSettings();
        try {
            String charset;
            byte[] responseBody = postMethod.getResponseBody();
            if (settings.getBoolean(HttpSettings.INCLUDE_RESPONSE_IN_TIME_TAKEN)) {
                this.timeTaken = postMethod.getTimeTakenUntilNow();
            }
            if ((charset = postMethod.getResponseCharSet()) == null) {
                charset = wsdlRequest.getEncoding();
            }
            charset = StringUtils.unquote(charset);
            this.responseContent = responseBody.length == 0 ? null : (charset == null ? new String(responseBody) : new String(responseBody, charset));
            this.prettyPrint = wsdlRequest.getSettings().getBoolean(WsdlSettings.PRETTY_PRINT_RESPONSE_MESSAGES);
            this.initHeaders(postMethod);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initHeaders(TimeablePostMethod postMethod) {
        Header[] headers;
        this.requestHeaders = new StringToStringMap();
        for (Header header : headers = postMethod.getRequestHeaders()) {
            this.requestHeaders.put(header.getName(), header.getValue());
        }
        this.responseHeaders = new StringToStringMap();
        for (Header header : headers = postMethod.getResponseHeaders()) {
            this.responseHeaders.put(header.getName(), header.getValue());
        }
        this.responseHeaders.put("#status#", postMethod.getStatusLine().toString());
    }

    public String getContentAsString() {
        if (this.prettyPrint) {
            this.responseContent = XmlUtils.prettyPrintXml(this.responseContent);
            this.prettyPrint = false;
        }
        return this.responseContent;
    }

    public long getContentLength() {
        return this.responseContent == null ? 0L : (long)this.responseContent.length();
    }

    public Request getRequest() {
        return this.wsdlRequest;
    }

    public long getTimeTaken() {
        return this.timeTaken;
    }

    public Attachment[] getAttachments() {
        return new Attachment[0];
    }

    public StringToStringMap getRequestHeaders() {
        return this.requestHeaders;
    }

    public StringToStringMap getResponseHeaders() {
        return this.responseHeaders;
    }

    public Attachment[] getAttachmentsForPart(String partName) {
        return new Attachment[0];
    }

    public String getRequestContent() {
        return this.requestContent;
    }

    public void setResponseContent(String responseContent) {
        this.responseContent = responseContent;
    }

    public SSLInfo getSSLInfo() {
        return this.sslInfo;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

