/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.testcase;

import com.eviware.soapui.model.testsuite.TestStepResult;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;

public class TestCaseLogModel
extends AbstractListModel {
    private List<Object> items = new ArrayList<Object>();
    private List<SoftReference<TestStepResult>> results = new ArrayList<SoftReference<TestStepResult>>();
    private int stepCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addText(String msg) {
        TestCaseLogModel testCaseLogModel = this;
        synchronized (testCaseLogModel) {
            this.items.add(msg);
            this.results.add(null);
            this.fireIntervalAdded(this, this.items.size() - 1, this.items.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTestStepResult(TestStepResult result) {
        TestCaseLogModel testCaseLogModel = this;
        synchronized (testCaseLogModel) {
            ++this.stepCount;
            int size = this.items.size();
            this.items.add("Step " + this.stepCount + " [" + result.getTestStep().getName() + "] " + (Object)((Object)result.getStatus()) + ": took " + result.getTimeTaken() + " ms");
            SoftReference<TestStepResult> ref = new SoftReference<TestStepResult>(result);
            this.results.add(ref);
            for (String msg : result.getMessages()) {
                this.items.add("-> " + msg);
                this.results.add(ref);
            }
            this.fireIntervalAdded(this, size, this.items.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        TestCaseLogModel testCaseLogModel = this;
        synchronized (testCaseLogModel) {
            int sz = this.getSize();
            this.items.clear();
            this.results.clear();
            this.stepCount = 0;
            this.fireIntervalRemoved(this, 0, sz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        TestCaseLogModel testCaseLogModel = this;
        synchronized (testCaseLogModel) {
            return this.items.size();
        }
    }

    public Object getElementAt(int arg0) {
        try {
            return this.items.get(arg0);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public TestStepResult getResultAt(int index) {
        if (index >= this.results.size()) {
            return null;
        }
        SoftReference<TestStepResult> result = this.results.get(index);
        return result == null ? null : result.get();
    }
}

