/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.support;

import com.eviware.soapui.impl.EmptyPanelBuilder;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.PanelBuilder;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.support.action.DefaultActionList;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.AbstractAction;
import javax.swing.Action;

public abstract class AbstractModelItem
implements ModelItem {
    private DefaultActionList actions;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected void addAction(Action action) {
        this.addAction(action, false);
    }

    protected void addAction(Action action, boolean isDefault) {
        if (this.actions == null) {
            this.initActions();
        }
        this.actions.addAction(action);
        if (isDefault) {
            this.actions.setDefaultAction(action);
        }
        this.notifyPropertyChanged(ModelItem.ACTIONS_PROPERTY, null, this.getActions());
    }

    private void initActions() {
        this.actions = new DefaultActionList(this.getName());
        this.actions.setDefaultAction(new ShowModelItemAction());
    }

    public ActionList getActions() {
        if (this.actions == null) {
            this.initActions();
        }
        return this.actions;
    }

    public PanelBuilder getPanelBuilder() {
        return EmptyPanelBuilder.get();
    }

    public String getDescription() {
        return this.getName();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void notifyPropertyChanged(String name, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(name, oldValue, newValue);
    }

    protected void notifyPropertyChanged(String name, int oldValue, int newValue) {
        this.propertyChangeSupport.firePropertyChange(name, oldValue, newValue);
    }

    protected void notifyPropertyChanged(String name, boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.firePropertyChange(name, oldValue, newValue);
    }

    public class ShowModelItemAction
    extends AbstractAction {
        public ShowModelItemAction() {
            super("Show Editor");
        }

        public void actionPerformed(ActionEvent e) {
            UISupport.selectAndShow(AbstractModelItem.this);
        }
    }
}

