/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.PanelBuilder;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.support.action.ActionSupport;
import com.eviware.soapui.support.action.DefaultActionList;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public abstract class AbstractTreeNode
implements SoapUITreeNode {
    private DummyModelItem modelItem;
    private JPopupMenu popup;
    private ActionList actions;

    public AbstractTreeNode(String name, ImageIcon icon) {
        this.modelItem = new DummyModelItem(name, icon);
    }

    public boolean valueChanged(Object newValue) {
        return false;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public JPopupMenu getPopup() {
        if (this.popup == null && this.actions != null) {
            this.popup = ActionSupport.buildPopup(this.actions);
        }
        return this.popup;
    }

    public void setLabel(String label) {
        this.modelItem.setLabel(label);
    }

    public ActionList getActions() {
        return this.actions;
    }

    public void addAction(Action action, boolean isDefault) {
        if (this.actions == null) {
            this.actions = new DefaultActionList(this.modelItem.getName());
        }
        this.actions.addAction(action);
        if (isDefault && this.actions instanceof DefaultActionList) {
            ((DefaultActionList)this.actions).setDefaultAction(action);
        }
    }

    public void setActions(ActionList actions) {
        this.actions = actions;
    }

    public Component getOverviewPanel() {
        return null;
    }

    public DesktopPanel getDesktopPanel() {
        return null;
    }

    public ModelItem getModelItem() {
        return this.modelItem;
    }

    public boolean hasContentPanel() {
        return false;
    }

    public String toString() {
        return this.modelItem.getName();
    }

    public void reorder(boolean notify) {
    }

    public class DummyModelItem
    implements ModelItem {
        private String name;
        private ImageIcon icon;
        private PropertyChangeSupport propertyChangeSupport;

        public DummyModelItem(String name, ImageIcon icon) {
            this.name = name;
            this.icon = icon;
        }

        public void setLabel(String label) {
            String oldName = this.name;
            this.name = label;
            if (this.propertyChangeSupport != null) {
                this.propertyChangeSupport.firePropertyChange(ModelItem.NAME_PROPERTY, oldName, label);
            }
        }

        public String getName() {
            return this.name;
        }

        public ImageIcon getIcon() {
            return this.icon;
        }

        public ActionList getActions() {
            return AbstractTreeNode.this.actions;
        }

        public PanelBuilder getPanelBuilder() {
            return null;
        }

        public String getDescription() {
            return this.name;
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            if (this.propertyChangeSupport == null) {
                this.propertyChangeSupport = new PropertyChangeSupport(this);
            }
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            if (this.propertyChangeSupport == null) {
                this.propertyChangeSupport = new PropertyChangeSupport(this);
            }
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            if (this.propertyChangeSupport != null) {
                this.propertyChangeSupport.removePropertyChangeListener(listener);
            }
        }

        public SoapUITreeNode getTreeNode() {
            return AbstractTreeNode.this;
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            if (this.propertyChangeSupport != null) {
                this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
            }
        }

        public Settings getSettings() {
            return null;
        }

        public void release() {
        }
    }
}

